/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.GhastEye;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class GhastEyeEvents {
    @SubscribeEvent
    public static void obtainRegenOnKill(LivingDeathEvent event) {
        Player player;
        GhastEye.Stats config = (GhastEye.Stats)GhastEye.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && !(player = (Player)entity).isSpectator()) {
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.GHAST_EYE.get());
            if (!stack.isEmpty()) {
                if (!player.hasEffect(MobEffects.REGENERATION)) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, config.regenerationTime, config.regenerationLevel));
                } else {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, Objects.requireNonNull(player.getEffect(MobEffects.REGENERATION)).getDuration() + config.regenerationExtraTime, config.regenerationLevel));
                }
            }
        }
    }
}

