/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.MinersSoul;
import io.wispforest.accessories.api.AccessoriesCapability;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class MinersSoulEvents {
    @SubscribeEvent
    public static void playerBreakBlock(BlockEvent.BreakEvent event) {
        MinersSoul.Stats config = (MinersSoul.Stats)MinersSoul.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.level().isClientSide && !player.getAbilities().instabuild) {
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.MINERS_SOUL.get());
            if (!stack.isEmpty()) {
                Level level = player.level();
                ItemStack itemStack = player.getMainHandItem();
                ItemStack fakeItemStack = new ItemStack((ItemLike)itemStack.getItem());
                ItemEnchantments enchantments = (ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS);
                RegistryAccess registries = level.registryAccess();
                HolderLookup.RegistryLookup enchantmentRegistry = registries.lookupOrThrow(Registries.ENCHANTMENT);
                Holder.Reference silkTouch = enchantmentRegistry.getOrThrow(Enchantments.SILK_TOUCH);
                Holder.Reference fortune = enchantmentRegistry.getOrThrow(Enchantments.FORTUNE);
                if (enchantments != null && enchantments.getLevel((Holder)silkTouch) > 0) {
                    return;
                }
                int bonusLevel = enchantments != null ? enchantments.getLevel((Holder)fortune) : 0;
                FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                fakePlayer.setItemSlot(EquipmentSlot.MAINHAND, fakeItemStack);
                ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(enchantments != null ? enchantments : ItemEnchantments.EMPTY);
                mutableEnchantments.upgrade((Holder)fortune, bonusLevel + config.extraLootingLevel);
                fakeItemStack.set(DataComponents.ENCHANTMENTS, (Object)mutableEnchantments.toImmutable());
                if (!(event.getState().getBlock() instanceof EntityBlock)) {
                    LootParams context;
                    LootTable loot = level.getServer().reloadableRegistries().getLootTable((ResourceKey)event.getState().getBlock().getLootTable().get());
                    ObjectArrayList drops = loot.getRandomItems(context = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)event.getPos())).withParameter(LootContextParams.TOOL, (Object)fakeItemStack).withParameter(LootContextParams.BLOCK_STATE, (Object)event.getState()).create(LootContextParamSets.BLOCK));
                    if (!drops.isEmpty()) {
                        ((ItemStack)drops.get(0)).setCount(((ItemStack)drops.get(0)).getCount() - 1);
                    }
                    for (ItemStack drop : drops) {
                        ItemEntity itemEntity = new ItemEntity(level, (double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ(), drop);
                        itemEntity.setDefaultPickUpDelay();
                        itemEntity.setPos(Vec3.atCenterOf((Vec3i)event.getPos()));
                        itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((level.random.nextFloat() - level.random.nextFloat()) * 0.1f), (double)(level.random.nextFloat() * 0.05f), (double)((level.random.nextFloat() - level.random.nextFloat()) * 0.1f)));
                        level.addFreshEntity((Entity)itemEntity);
                    }
                }
            }
        }
    }
}

