/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.MissingPage;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class MissingPageEvents {
    public static boolean isValidTarget(LivingEntity ent) {
        return ent.getType() != EntityType.PLAYER && !ent.isInvulnerable();
    }

    @SubscribeEvent
    public static void triggerDamageReflection(LivingDamageEvent.Post event) {
        MissingPage.Stats config = (MissingPage.Stats)MissingPage.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        DamageSource source = event.getSource();
        Entity src = source.getEntity();
        Random random = new Random();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.MISSING_PAGE.get());
            if (!stack.isEmpty() && random.nextInt(100) <= config.activationPercentage) {
                AABB targetBox = new AABB(player.position(), player.position()).inflate((double)config.radiusInBlocks);
                List foundTarget = event.getEntity().level().getEntitiesOfClass(LivingEntity.class, targetBox, MissingPageEvents::isValidTarget);
                if (!(src == null || src instanceof Player || foundTarget.isEmpty() || player.level().isClientSide)) {
                    for (LivingEntity livingEntity2 : foundTarget) {
                        ((ServerLevel)livingEntity2.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.SOUL, livingEntity2.getX(), livingEntity2.getY(), livingEntity2.getZ(), 35, 1.0, 1.0, 1.0, 0.1);
                        livingEntity2.hurt(livingEntity2.damageSources().generic(), livingEntity2.getMaxHealth() * (config.percentageOfDamage / 100.0f));
                    }
                }
            }
        }
    }
}

