/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.trinkets.SigilOfBaphomet;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class SigilOfBaphometEvents {
    @SubscribeEvent
    public static void handleSigilKillCount(LivingDeathEvent event) {
        SigilOfBaphomet.Stats config = (SigilOfBaphomet.Stats)SigilOfBaphomet.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
            if (accessories == null) {
                return;
            }
            List stack = accessories.getEquipped(ModItems.SIGIL_OF_BAPHOMET.get());
            if (!stack.isEmpty() && (Integer)((SlotEntryReference)stack.getFirst()).stack().getOrDefault(ModDataComponents.SIGIL_COUNT.get(), (Object)0) <= 10) {
                ((SlotEntryReference)stack.getFirst()).stack().set(ModDataComponents.SIGIL_COUNT.get(), (Object)((Integer)((SlotEntryReference)stack.getFirst()).stack().getOrDefault(ModDataComponents.SIGIL_COUNT.get(), (Object)0) + 1));
            }
        }
    }

    @SubscribeEvent
    public static void grantSigilImmunityOnDamage(LivingDamageEvent.Pre event) {
        SigilOfBaphomet.Stats config = (SigilOfBaphomet.Stats)SigilOfBaphomet.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEntity() == player) {
                AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
                if (accessories == null) {
                    return;
                }
                List stack = accessories.getEquipped(ModItems.SIGIL_OF_BAPHOMET.get());
                if (!stack.isEmpty() && (Integer)((SlotEntryReference)stack.getFirst()).stack().getOrDefault(ModDataComponents.SIGIL_COUNT.get(), (Object)0) > 0 && !player.level().isClientSide) {
                    ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, player.getX(), player.getY(), player.getZ(), 50, 0.5, 1.0, 0.5, 0.1);
                    event.setNewDamage(0.0f);
                }
            }
        }
    }
}

