/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FateEmerald
extends TrinketItem<Stats> {
    public static FateEmerald INSTANCE;

    public FateEmerald() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"fate_emerald"))), null, Stats.class));
        INSTANCE = this;
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_1").withStyle(ChatFormatting.GOLD));
                String formattedSeconds = String.format("%.2f", (double)config.timeUntilUnequip / 20.0);
                String formattedHunger = String.format("%.2f", Float.valueOf(config.hungerExhaustionRate));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_2", (Object[])new Object[]{formattedSeconds}).withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_3", (Object[])new Object[]{formattedHunger}).withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public void onEquip(ItemStack stack, SlotReference reference) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        config.timeUntilUnequip = 1200.0f;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level world = player.level();
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (config.backupTimeUntilUnequip == 0.0f) {
            config.backupTimeUntilUnequip = config.timeUntilUnequip;
        }
        if (config.timeUntilUnequip > 0.0f) {
            config.timeUntilUnequip -= 1.0f;
        }
        if (!world.isClientSide() && player.tickCount % 20 == 0) {
            player.causeFoodExhaustion(config.hungerExhaustionRate);
        }
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        if (!(livingEntity instanceof Player)) {
            return true;
        }
        Player player = (Player)livingEntity;
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (config.timeUntilUnequip <= 0.0f) {
            config.timeUntilUnequip = config.backupTimeUntilUnequip;
            config.resetTimerFlag = true;
        }
        return config.resetTimerFlag || player.getAbilities().instabuild;
    }

    public static class Stats
    extends TrinketsStats {
        public int discountPercentage = 100;
        public float timeUntilUnequip = 0.0f;
        public float hungerExhaustionRate = 0.1f;
        public boolean isEnable = true;
        float backupTimeUntilUnequip = 0.0f;
        boolean resetTimerFlag = false;
    }
}

