/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class FragileCloud
extends TrinketItem<Stats> {
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"slow_falling"), -0.07, AttributeModifier.Operation.ADD_VALUE);
    public static FragileCloud INSTANCE;

    public FragileCloud() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"fragile_cloud"))), null, Stats.class));
        INSTANCE = this;
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void tick(ItemStack stack, SlotReference reference) {
        super.tick(stack, reference);
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = reference.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.level().isClientSide && !player.isSpectator()) {
            List stack0 = AccessoriesCapability.get((LivingEntity)player).getEquipped(ModItems.FRAGILE_CLOUD.get());
            List stack1 = AccessoriesCapability.get((LivingEntity)player).getEquipped(ModItems.MOON_STONE.get());
            AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
            if (!stack0.isEmpty() && stack1.isEmpty()) {
                if (!(player.isFallFlying() || player.onGround() || player.isInWater())) {
                    assert (gravity != null);
                    if (!gravity.hasModifier(SLOW_FALLING.id()) && player.getDeltaMovement().y < -0.3) {
                        gravity.addPermanentModifier(SLOW_FALLING);
                    }
                    player.resetFallDistance();
                    if (gravity.hasModifier(SLOW_FALLING.id())) {
                        double particleX = player.getX() + (double)(player.getRandom().nextBoolean() ? -1 : 1) * Math.pow(player.getRandom().nextFloat(), 1.0) * 1.0;
                        double particleY = player.getY() + (double)(player.getRandom().nextFloat() * 1.0f) - 2.0;
                        double particleZ = player.getZ() + (double)(player.getRandom().nextBoolean() ? -1 : 1) * Math.pow(player.getRandom().nextFloat(), 1.0) * 1.0;
                        ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, particleX, particleY, particleZ, 1, 1.0, 1.0, 1.0, 0.1);
                    }
                } else {
                    assert (gravity != null);
                    if (gravity.hasModifier(SLOW_FALLING.id())) {
                        gravity.removeModifier(SLOW_FALLING);
                    }
                }
            } else {
                assert (gravity != null);
                if (gravity.hasModifier(SLOW_FALLING.id())) {
                    gravity.removeModifier(SLOW_FALLING);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fragile_cloud_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fragile_cloud_1").withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public boolean isEnable = true;
    }
}

