/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;

public class IceCube
extends TrinketItem<Stats> {
    public static IceCube INSTANCE;

    public IceCube() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"ice_cube"))), null, Stats.class));
        INSTANCE = this;
    }

    public void tick(ItemStack stack, SlotReference reference) {
        super.tick(stack, reference);
        LivingEntity livingEntity = reference.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(player instanceof ServerPlayer) || player.isSpectator() || player.level().isClientSide) {
            return;
        }
        Level world = player.level();
        BlockPos pos = player.blockPosition();
        if (player.onGround()) {
            BlockState blockstate = Blocks.FROSTED_ICE.defaultBlockState();
            float radius = Math.min(16, 2 + config.frostWalkerLevel);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset((int)(-radius), -1, (int)(-radius)), (BlockPos)pos.offset((int)radius, -1, (int)radius))) {
                boolean isFullWaterBlock;
                if (!blockPos.closerToCenterThan((Position)player.position(), (double)radius)) continue;
                mutablePos.set(blockPos.getX(), blockPos.getY() + 1, blockPos.getZ());
                BlockState aboveBlockState = world.getBlockState((BlockPos)mutablePos);
                if (!aboveBlockState.isAir()) continue;
                BlockState belowBlockState = world.getBlockState(blockPos);
                boolean bl = isFullWaterBlock = belowBlockState.getBlock() == Blocks.WATER && (Integer)belowBlockState.getValue((Property)LiquidBlock.LEVEL) == 0;
                if (belowBlockState != FrostedIceBlock.meltsInto() || !isFullWaterBlock || !blockstate.canSurvive((LevelReader)world, blockPos) || !world.isUnobstructed(blockstate, blockPos, CollisionContext.empty())) continue;
                world.setBlockAndUpdate(blockPos, blockstate);
                world.scheduleTick(blockPos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)player.getRandom(), (int)60, (int)120));
            }
            BlockState iceBlock = Blocks.ICE.defaultBlockState();
            ((ServerLevel)world).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, iceBlock), player.getX(), player.getY(), player.getZ(), 1, 0.5, 1.0, 0.5, 0.1);
        }
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.ice_cube_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.ice_cube_1", (Object[])new Object[]{config.slownessLevel + 1, config.slownessTime / 20}).withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.ice_cube_2").withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int slownessTime = 200;
        public int slownessLevel = 1;
        public int frostWalkerLevel = 3;
        public boolean isEnable = true;
        public boolean inmuneToFreezing = true;
    }
}

