/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SigilOfBaphomet
extends TrinketItem<Stats> {
    public static SigilOfBaphomet INSTANCE;

    public SigilOfBaphomet() {
        super(new TrinketData(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"sigil_of_baphomet"))), null, Stats.class));
        INSTANCE = this;
    }

    public boolean canEquipFromUse(ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(ItemStack stack, SlotReference reference) {
        reference.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void tick(ItemStack stack, SlotReference reference) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(reference.entity() instanceof ServerPlayer)) {
            return;
        }
        if (!stack.isEmpty() && (Integer)stack.getOrDefault(ModDataComponents.SIGIL_COUNT.get(), (Object)0) > 0) {
            stack.set(ModDataComponents.SIGIL_COUNT.get(), (Object)((Integer)stack.getOrDefault(ModDataComponents.SIGIL_COUNT.get(), (Object)0) - 1));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.sigil_of_baphomet_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.sigil_of_baphomet_1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.sigil_of_baphomet_2").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.sigil_of_baphomet_3").withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public boolean isEnable = true;
    }
}

