/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.configs;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.ShaderManager;
import einstein.subtle_effects.util.Util;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;

@Translation(prefix="config.subtle_effects.general")
public class ModGeneralConfigs
extends Config {
    public boolean mobSkullShaders;
    @ValidatedInt.Restrict(min=1, max=32)
    public int particleRenderDistance = 5;
    public boolean cullParticlesWithNoAlpha = true;
    public boolean cullParticlesInUnloadedChunks = true;
    public ValidatedFloat sparksScale = new ValidatedFloat(1.0f, 2.0f, 1.0f);
    public ValidatedFloat fireHeight = new ValidatedFloat(0.0f, 0.4f, -0.5f);

    public ModGeneralConfigs() {
        super(SubtleEffects.loc("general"));
    }

    public void onUpdateClient() {
        Minecraft minecraft = Minecraft.getInstance();
        TickerManager.clear();
        if (minecraft.level != null && minecraft.options.getCameraType().isFirstPerson()) {
            if (!this.mobSkullShaders) {
                ((ShaderManager)minecraft.gameRenderer).subtleEffects$clearShader();
                return;
            }
            LocalPlayer player = minecraft.player;
            if (player != null) {
                Util.applyHelmetShader(player.getInventory().getArmor(3));
            }
        }
    }
}

