/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModDamageListeners;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private final Entity subtleEffects$me = (Entity)this;

    @Shadow
    protected abstract boolean isInvulnerableToBase(DamageSource var1);

    @Inject(method={"hurtOrSimulate"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurtClient(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    public <T extends Entity> void hurtClient(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = this.subtleEffects$me;
        if (entity instanceof LivingEntity) {
            EntityType type;
            LivingEntity entity2 = (LivingEntity)entity;
            if (!this.isInvulnerableToBase(source) && source.getEntity() instanceof LivingEntity && entity2.isAlive() && entity2.hurtTime == 0 && ModDamageListeners.REGISTERED.containsKey(type = entity2.getType())) {
                ModDamageListeners.REGISTERED.get(type).apply((Entity)this, entity2.level(), entity2.getRandom());
            }
        }
    }
}

