/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle.bubbles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.SpriteSetSetter;
import einstein.subtle_effects.util.Util;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.particle.WaterCurrentDownParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BubbleParticle.class, BubbleColumnUpParticle.class, WaterCurrentDownParticle.class})
public abstract class BubbleParticleMixin
extends TextureSheetParticle
implements SpriteSetSetter {
    @Unique
    private TextureAtlasSprite subtleEffects$overlaySprite;

    protected BubbleParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    protected void renderRotatedQuad(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        super.renderRotatedQuad(buffer, quaternion, x, y, z, partialTicks);
        if (this.subtleEffects$overlaySprite != null && Util.isBCWPPackLoaded()) {
            int lightColor = this.getLightColor(partialTicks);
            float quadSize = this.getQuadSize(partialTicks);
            float u0 = this.subtleEffects$overlaySprite.getU0();
            float u1 = this.subtleEffects$overlaySprite.getU1();
            float v0 = this.subtleEffects$overlaySprite.getV0();
            float v1 = this.subtleEffects$overlaySprite.getV1();
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, 1.0f, -1.0f, quadSize, u1, v1, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, 1.0f, 1.0f, quadSize, u1, v0, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, -1.0f, 1.0f, quadSize, u0, v0, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, -1.0f, -1.0f, quadSize, u0, v1, lightColor);
        }
    }

    @Unique
    private void subtleEffects$renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(1.0f, 1.0f, 1.0f, this.alpha).setLight(packedLight);
    }

    @Override
    public void subtleEffects$setSpriteSet(SpriteSet sprites) {
        List<TextureAtlasSprite> textures = Services.PARTICLE_HELPER.getSpritesFromSet(sprites);
        if (textures != null && textures.size() > 1 && Util.isBCWPPackLoaded()) {
            this.setSprite(textures.getFirst());
            this.subtleEffects$overlaySprite = textures.get(1);
        }
    }
}

