/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.SparkType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.phys.Vec3;

public class MinecartSparksTicker
extends Ticker<AbstractMinecart> {
    private int ticksInAir;
    private int sparksTimer;
    private int sparksCount;
    private Vec3 deltaMovement;

    public MinecartSparksTicker(AbstractMinecart entity) {
        super(entity);
        this.deltaMovement = entity.getDeltaMovement();
    }

    @Override
    public void tick() {
        boolean onRails;
        Vec3 currentDeltaMovement = ((AbstractMinecart)this.entity).getDeltaMovement();
        if (currentDeltaMovement.x() == 0.0 && currentDeltaMovement.z() == 0.0) {
            return;
        }
        if (currentDeltaMovement.x() < 0.0 && this.deltaMovement.x() > 0.0 || currentDeltaMovement.x() > 0.0 && this.deltaMovement.x() < 0.0 || currentDeltaMovement.z() < 0.0 && this.deltaMovement.z() > 0.0 || currentDeltaMovement.z() > 0.0 && this.deltaMovement.z() < 0.0) {
            this.sparksTimer = 0;
            this.sparksCount = 0;
            return;
        }
        this.deltaMovement = currentDeltaMovement;
        BlockPos pos = ((AbstractMinecart)this.entity).blockPosition();
        BlockPos belowPos = pos.below();
        if (this.level.getBlockState(belowPos).is(BlockTags.RAILS)) {
            pos = belowPos;
        }
        if (onRails = BaseRailBlock.isRail((Level)this.level, (BlockPos)pos)) {
            if (this.ticksInAir >= 10) {
                this.sparksTimer = 40;
                this.sparksCount = 20;
            } else if (this.ticksInAir >= 5) {
                this.sparksTimer = 20;
                this.sparksCount = 5;
            }
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        if (this.sparksTimer > 0) {
            --this.sparksTimer;
            for (int i = 0; i < this.sparksCount; ++i) {
                this.level.addParticle((ParticleOptions)SparkParticle.create(SparkType.METAL, this.random), ((AbstractMinecart)this.entity).position().x() + (double)((AbstractMinecart)this.entity).getBbWidth() * this.random.nextDouble() - 1.0, ((AbstractMinecart)this.entity).getY() + Mth.clamp((double)this.random.nextFloat(), (double)0.2, (double)0.5), ((AbstractMinecart)this.entity).position().z() + (double)((AbstractMinecart)this.entity).getBbWidth() * this.random.nextDouble() - 1.0, (double)Mth.nextFloat((RandomSource)this.random, (float)0.1f, (float)0.2f) * (this.deltaMovement.x() * 1.5), (double)Mth.nextFloat((RandomSource)this.random, (float)0.1f, (float)0.2f), (double)Mth.nextFloat((RandomSource)this.random, (float)0.1f, (float)0.2f) * (this.deltaMovement.z() * 1.5));
            }
            return;
        }
        this.sparksCount = 0;
    }
}

