/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnUtil {
    public static void spawnSparks(Level level, RandomSource random, BlockPos pos, SparkType sparkType, Box box, Vec3 maxSpeeds, int count, List<Integer> colors) {
        if (random.nextBoolean()) {
            Vec3 start = box.min();
            Vec3 end = box.max();
            for (int i = 0; i < count; ++i) {
                level.addParticle((ParticleOptions)SparkParticle.create(sparkType, random, colors), (double)pos.getX() + Mth.nextDouble((RandomSource)random, (double)start.x, (double)end.x), (double)pos.getY() + Mth.nextDouble((RandomSource)random, (double)start.y, (double)end.y), (double)pos.getZ() + Mth.nextDouble((RandomSource)random, (double)start.z, (double)end.z), MathUtil.nextNonAbsDouble(random, maxSpeeds.x()), MathUtil.nextNonAbsDouble(random, maxSpeeds.y()), MathUtil.nextNonAbsDouble(random, maxSpeeds.z()));
            }
        }
    }

    public static void spawnParticlesAroundBlock(ParticleOptions particle, Level level, BlockPos pos, RandomSource random, int perSideChance) {
        ParticleSpawnUtil.spawnParticlesAroundBlock(particle, level, pos, random, 0.0625f, perSideChance > 0 ? direction -> random.nextInt(perSideChance) != 0 : null);
    }

    public static void spawnParticlesAroundBlock(ParticleOptions particle, Level level, BlockPos pos, RandomSource random, float offset, @Nullable Predicate<Direction> predicate) {
        for (Direction direction : Direction.values()) {
            if (predicate != null && predicate.test(direction)) {
                return;
            }
            BlockPos relativePos = pos.relative(direction);
            if (level.getBlockState(relativePos).isSolidRender()) continue;
            ParticleSpawnUtil.spawnParticlesOnSide(particle, offset, direction, level, pos, random, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesOnSide(ParticleOptions particle, float offset, Direction direction, Level level, BlockPos pos, RandomSource random, double xSpeed, double ySpeed, double zSpeed) {
        double offsetFromCenter = 0.5 + (double)offset;
        Direction.Axis axis = direction.getAxis();
        double xOffset = axis == Direction.Axis.X ? 0.5 + offsetFromCenter * (double)direction.getStepX() : (double)random.nextFloat();
        double yOffset = axis == Direction.Axis.Y ? 0.5 + offsetFromCenter * (double)direction.getStepY() : (double)random.nextFloat();
        double zOffset = axis == Direction.Axis.Z ? 0.5 + offsetFromCenter * (double)direction.getStepZ() : (double)random.nextFloat();
        level.addParticle(particle, (double)pos.getX() + xOffset, (double)pos.getY() + yOffset, (double)pos.getZ() + zOffset, xSpeed, ySpeed, zSpeed);
    }

    public static void spawnFallDustClouds(LivingEntity entity, float distance, int fallDamage) {
        Level level = entity.level();
        if (level.isClientSide && entity.equals((Object)Minecraft.getInstance().player)) {
            ParticleSpawnUtil.spawnEntityFellParticles(entity, entity.getY(), distance, fallDamage, ModConfigs.ENTITIES.dustClouds.playerFell);
        } else if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            Services.NETWORK.sendToClientsTracking(entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null, serverLevel, entity.blockPosition(), new ClientBoundEntityFellPacket(entity.getId(), entity.getY(), distance, fallDamage));
        }
    }

    public static void spawnCreatureMovementDustClouds(LivingEntity entity, Level level, RandomSource random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.mobRunning) {
            ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig(entity, level, random, YSpeedModifier);
        }
    }

    public static void spawnCreatureMovementDustCloudsNoConfig(LivingEntity entity, Level level, RandomSource random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.isRainingAt(entity.blockPosition())) {
            return;
        }
        level.addParticle((ParticleOptions)ModParticles.LARGE_DUST_CLOUD.get(), entity.position().x + (double)entity.getBbWidth() * random.nextDouble() - 1.0, entity.getY() + Math.max(Math.min((double)random.nextFloat(), 0.5), 0.2), entity.position().z + (double)entity.getBbWidth() * random.nextDouble() - 1.0, 0.0, random.nextDouble() * (double)YSpeedModifier, 0.0);
    }

    public static void spawnLavaSparks(Level level, BlockPos pos, RandomSource random, int count) {
        for (int i = 0; i < count; ++i) {
            level.addParticle((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random), (double)pos.getX() + 0.5 + random.nextDouble() / 2.0 * (double)MathUtil.nextSign(random), (double)pos.getY() + random.nextDouble() * (double)random.nextInt(3), (double)pos.getZ() + 0.5 + random.nextDouble() / 2.0 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.07), MathUtil.nextNonAbsDouble(random, 0.1));
        }
    }

    public static void spawnCmdBlockParticles(Level level, Vec3 pos, RandomSource random, BiPredicate<Direction, Vec3> directionValidator) {
        for (Direction direction : Direction.values()) {
            Vec3 endPos = pos.relative(direction, 1.0);
            Vec3 relativePos = endPos.relative(direction, -0.5);
            if (!directionValidator.test(direction, endPos)) continue;
            Vec3 speed = pos.vectorTo(relativePos).offsetRandom(random, 1.0f);
            level.addParticle((ParticleOptions)new DirectionParticleOptions(direction), endPos.x(), endPos.y(), endPos.z(), speed.x(), speed.y(), speed.z());
        }
    }

    public static void spawnHeatedWaterParticles(Level level, BlockPos pos, RandomSource random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig) {
        int brightness = level.getBrightness(LightLayer.BLOCK, pos);
        switch (ModConfigs.BLOCKS.steam.spawnLogic) {
            case NEAR_LAVA: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            if (!level.getFluidState(pos.offset(x, y, z)).is(FluidTags.LAVA)) continue;
                            ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
                        }
                    }
                }
                break;
            }
            case BRIGHTNESS: {
                if (brightness <= (Integer)ModConfigs.BLOCKS.steam.steamingThreshold.get() && !level.getBlockState(pos.below()).is(Blocks.MAGMA_BLOCK)) break;
                ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
            }
        }
    }

    private static void spawnHeatedWaterParticles(Level level, BlockPos pos, RandomSource random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig, int brightness) {
        if (steamConfig && !isFalling && !Util.isSolidOrNotEmpty(level, pos.above())) {
            level.addParticle((ParticleOptions)ModParticles.STEAM.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.875 + MathUtil.nextDouble(random, 0.5), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (boilingConfig && brightness >= (Integer)ModConfigs.BLOCKS.steam.boilingThreshold.get()) {
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + random.nextDouble(), Mth.clamp((double)random.nextDouble(), (double)pos.getY(), (double)((double)pos.getY() + height)), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnEntityFellParticles(LivingEntity entity, double y, float distance, int fallDamage, boolean config) {
        if (!config || entity.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return;
        }
        if (!(fallDamage > 0 || entity instanceof AbstractHorse && (double)distance > (entity instanceof Camel ? 0.5 : 1.0))) {
            return;
        }
        if (entity.isInWater() || entity.isInLava() || entity.isInPowderSnow) {
            return;
        }
        Level level = entity.level();
        RandomSource random = entity.getRandom();
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.isRainingAt(entity.blockPosition())) {
            return;
        }
        if (!level.getFluidState(entity.getOnPos().atY(Mth.floor((double)y))).isEmpty()) {
            return;
        }
        if (fallDamage < 4) {
            for (int i = 0; i < 5; ++i) {
                level.addParticle((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.getRandomX(1.0), y + Math.max(Math.min((double)random.nextFloat(), 0.5), 0.2), entity.getRandomZ(1.0), 0.3 * (double)MathUtil.nextSign(random), random.nextDouble(), 0.3 * (double)MathUtil.nextSign(random));
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)ModParticles.LARGE_DUST_CLOUD.get(), entity.getRandomX(1.0), y + Math.max(Math.min((double)random.nextFloat(), 0.5), 0.2), entity.getRandomZ(1.0), 0.5 * (double)MathUtil.nextSign(random), random.nextDouble() * 3.0, 0.5 * (double)MathUtil.nextSign(random));
        }
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, RandomSource random, Vec3 offset, float partialTick) {
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, random, new Vec3(((double)random.nextFloat() - 0.5) * 0.3, (double)(-random.nextFloat()) * 0.6 - 0.3, 0.6).add(offset), new Vec3(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1 + 0.05, 0.0), partialTick);
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, RandomSource random, Vec3 offset, Vec3 speed, float partialTick) {
        speed = speed.xRot(-entity.getViewXRot(partialTick) * ((float)Math.PI / 180));
        speed = speed.yRot(-entity.getViewYRot(partialTick) * ((float)Math.PI / 180));
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, offset, speed, partialTick);
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, Vec3 offset, Vec3 speed, float partialTick) {
        ParticleSpawnUtil.spawnEntityHeadParticle(options, entity, level, offset.add(0.0, 0.0, 0.6), speed, partialTick);
    }

    public static void spawnEntityHeadParticle(ParticleOptions options, LivingEntity entity, Level level, Vec3 pos, Vec3 speed, float partialTick) {
        pos = pos.xRot(-entity.getViewXRot(partialTick) * ((float)Math.PI / 180));
        pos = pos.yRot(-entity.getViewYRot(partialTick) * ((float)Math.PI / 180));
        pos = pos.add(entity.getX(), entity.getEyeY(), entity.getZ());
        level.addParticle(options, pos.x(), pos.y(), pos.z(), speed.x(), speed.y(), speed.z());
    }
}

