/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import plus.dragons.visuality.particle.type.ColorScaleParticleType;

public class SlimeParticle
extends TextureSheetParticle {
    private SlimeParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float scale) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.setColor(r, g, b);
        this.setAlpha(0.8f);
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.gravity = 1.0f;
        this.scale(scale + (float)this.random.nextInt(6) / 10.0f);
        this.lifetime = 10 + this.random.nextInt(7);
    }

    public void tick() {
        if (this.age > this.lifetime / 2) {
            this.setAlpha(1.0f - ((float)this.age - (float)(this.lifetime / 2)) / (float)this.lifetime);
        }
        super.tick();
        if (this.onGround) {
            this.gravity = 0.0f;
            this.setParticleSpeed(0.0, 0.0, 0.0);
            this.setPos(this.xo, this.yo + 0.1, this.zo);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorScaleParticleType.Options>
    {
        public Particle createParticle(ColorScaleParticleType.Options options, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            SlimeParticle particle = new SlimeParticle(world, x, y, z, options.r, options.g, options.b, options.scale);
            particle.setSprite(this.sprites.get(world.random));
            return particle;
        }
    }
}

