/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class SolidFallingParticle
extends RisingParticle {
    public SolidFallingParticle(ClientLevel level, double x, double y, double z, double velX, double velY, double velZ) {
        super(level, x, y, z, velX, velY, velZ);
        this.scale(1.1f + (float)level.random.nextInt(6) / 10.0f);
        this.roll = this.oRoll = this.random.nextFloat() * ((float)Math.PI * 2);
        this.yd = -0.25;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 12;
    }

    public void tick() {
        if (this.age > this.lifetime / 2) {
            this.setAlpha(1.0f - ((float)this.age - (float)(this.lifetime / 2)) / (float)this.lifetime);
        }
        super.tick();
        if (this.age == 1) {
            this.xd += (Math.random() * 2.0 - 1.0) * 0.2;
            this.yd = 0.3 + (double)this.random.nextInt(11) / 100.0;
            this.zd += (Math.random() * 2.0 - 1.0) * 0.2;
        } else if (this.age <= 10) {
            this.yd -= 0.05 + (double)this.age / 200.0;
        }
        if (this.onGround) {
            this.setParticleSpeed(0.0, 0.0, 0.0);
            this.setPos(this.xo, this.yo + 0.1, this.zo);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            SolidFallingParticle particle = new SolidFallingParticle(world, x, y, z, velX, velY, velZ);
            particle.setSpriteFromAge(this.sprites);
            return particle;
        }
    }
}

