/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.config.v2.impl;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.config.ConfigEntry;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.ConfigField;
import dev.isxander.yacl3.config.v2.api.ConfigSerializer;
import dev.isxander.yacl3.config.v2.api.FieldAccess;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.OptionAccess;
import dev.isxander.yacl3.config.v2.impl.ConfigFieldImpl;
import dev.isxander.yacl3.config.v2.impl.ReflectionFieldAccess;
import dev.isxander.yacl3.config.v2.impl.autogen.OptionAccessImpl;
import dev.isxander.yacl3.config.v2.impl.autogen.OptionFactoryRegistry;
import dev.isxander.yacl3.config.v2.impl.autogen.YACLAutoGenException;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class ConfigClassHandlerImpl<T>
implements ConfigClassHandler<T> {
    private final Class<T> configClass;
    private final ResourceLocation id;
    private final boolean supportsAutoGen;
    private final ConfigSerializer<T> serializer;
    private final ConfigFieldImpl<?>[] fields;
    private T instance;
    private final T defaults;
    private final Constructor<T> noArgsConstructor;

    public ConfigClassHandlerImpl(Class<T> configClass, ResourceLocation id, Function<ConfigClassHandler<T>, ConfigSerializer<T>> serializerFactory) {
        this.configClass = configClass;
        this.id = id;
        this.supportsAutoGen = id != null && YACLPlatform.getEnvironment().isClient();
        try {
            this.noArgsConstructor = configClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new YACLAutoGenException("Failed to find no-args constructor for config class %s.".formatted(configClass.getName()), e);
        }
        this.instance = this.createNewObject();
        this.defaults = this.createNewObject();
        this.detectOldAnnotation(configClass.getDeclaredFields());
        this.fields = this.discoverFields();
        this.serializer = serializerFactory.apply(this);
    }

    private ConfigFieldImpl<?>[] discoverFields() {
        return (ConfigFieldImpl[])Arrays.stream(this.configClass.getDeclaredFields()).peek(field -> field.setAccessible(true)).filter(field -> field.isAnnotationPresent(SerialEntry.class) || field.isAnnotationPresent(AutoGen.class)).map(field -> new ConfigFieldImpl(new ReflectionFieldAccess((Field)field, this.instance), new ReflectionFieldAccess((Field)field, this.defaults), this, field.getAnnotation(SerialEntry.class), field.getAnnotation(AutoGen.class))).toArray(ConfigFieldImpl[]::new);
    }

    @Override
    public T instance() {
        return this.instance;
    }

    @Override
    public T defaults() {
        return this.defaults;
    }

    @Override
    public Class<T> configClass() {
        return this.configClass;
    }

    public ConfigFieldImpl<?>[] fields() {
        return this.fields;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public boolean supportsAutoGen() {
        return this.supportsAutoGen;
    }

    @Override
    public YetAnotherConfigLib generateGui() {
        if (!this.supportsAutoGen()) {
            throw new YACLAutoGenException("Auto GUI generation is not supported for this config class. You either need to enable it in the builder or you are attempting to create a GUI in a dedicated server environment.");
        }
        boolean hasAutoGenFields = Arrays.stream(this.fields()).anyMatch(field -> field.autoGen().isPresent());
        if (!hasAutoGenFields) {
            throw new YACLAutoGenException("No fields in this config class are annotated with @AutoGen. You must annotate at least one field with @AutoGen to generate a GUI.");
        }
        OptionAccessImpl storage = new OptionAccessImpl();
        LinkedHashMap categories = new LinkedHashMap();
        for (ConfigFieldImpl<?> configField : this.fields()) {
            configField.autoGen().ifPresent(autoGen -> {
                Option option;
                CategoryAndGroups groups = categories.computeIfAbsent(autoGen.category(), k -> new CategoryAndGroups(ConfigCategory.createBuilder().name((Component)Component.translatable((String)"yacl3.config.%s.category.%s".formatted(this.id().toString(), k))), new LinkedHashMap<String, OptionAddable>()));
                OptionAddable group = groups.groups().computeIfAbsent(autoGen.group().orElse(""), k -> {
                    if (k.isEmpty()) {
                        return groups.category();
                    }
                    return OptionGroup.createBuilder().name((Component)Component.translatable((String)"yacl3.config.%s.category.%s.group.%s".formatted(this.id().toString(), autoGen.category(), k)));
                });
                try {
                    option = this.createOption(configField, storage);
                }
                catch (Exception e) {
                    throw new YACLAutoGenException("Failed to create option for field '%s'".formatted(configField.access().name()), e);
                }
                storage.putOption(configField.access().name(), option);
                group.option(option);
            });
        }
        storage.checkBadOperations();
        categories.values().forEach(CategoryAndGroups::finaliseGroups);
        YetAnotherConfigLib.Builder yaclBuilder = YetAnotherConfigLib.createBuilder().save(this.serializer()::save).title((Component)Component.translatable((String)"yacl3.config.%s.title".formatted(this.id().toString())));
        categories.values().forEach(category -> yaclBuilder.category(category.category().build()));
        return yaclBuilder.build();
    }

    private <U> Option<U> createOption(ConfigField<U> configField, OptionAccess storage) {
        return OptionFactoryRegistry.createOption(((ReflectionFieldAccess)configField.access()).field(), configField, storage).orElseThrow(() -> new YACLAutoGenException("Failed to create option for field %s".formatted(configField.access().name())));
    }

    @Override
    public ConfigSerializer<T> serializer() {
        return this.serializer;
    }

    @Override
    public boolean load() {
        Object newInstance = this.createNewObject();
        Map<ConfigFieldImpl, ReflectionFieldAccess> accessBufferImpl = Arrays.stream(this.fields()).map(field -> new AbstractMap.SimpleImmutableEntry((ConfigFieldImpl)field, new ReflectionFieldAccess(((ReflectionFieldAccess)field.access()).field(), newInstance))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<ConfigField<?>, FieldAccess<?>> accessBuffer = accessBufferImpl.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ConfigSerializer.LoadResult loadResult = ConfigSerializer.LoadResult.FAILURE;
        Throwable error = null;
        try {
            loadResult = this.serializer().loadSafely(accessBuffer);
        }
        catch (Throwable e) {
            error = e;
        }
        switch (loadResult) {
            case DIRTY: 
            case SUCCESS: {
                this.instance = newInstance;
                for (ConfigFieldImpl<?> field2 : this.fields()) {
                    field2.setFieldAccess(accessBufferImpl.get(field2));
                }
                if (loadResult == ConfigSerializer.LoadResult.DIRTY) {
                    this.save();
                }
            }
            case NO_CHANGE: {
                return true;
            }
            case FAILURE: {
                YACLConstants.LOGGER.error("Unsuccessful load of config class '{}'. The load will be abandoned and config remains unchanged.", (Object)this.configClass.getSimpleName(), (Object)error);
            }
        }
        return false;
    }

    @Override
    public void save() {
        this.serializer().save();
    }

    private T createNewObject() {
        try {
            return this.noArgsConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new YACLAutoGenException("Failed to create instance of config class '%s' with no-args constructor.".formatted(this.configClass.getName()), e);
        }
    }

    private void detectOldAnnotation(Field[] fields) {
        boolean hasOldConfigEntry = Arrays.stream(fields).anyMatch(field -> field.isAnnotationPresent(ConfigEntry.class));
        Validate.isTrue((!hasOldConfigEntry ? 1 : 0) != 0, (String)"At least one field in %s is still annotated with the deprecated @ConfigEntry annotation. This is incorrect. Use @SerialEntry.".formatted(this.configClass.getName()), (Object[])new Object[0]);
    }

    private record CategoryAndGroups(ConfigCategory.Builder category, Map<String, OptionAddable> groups) {
        private void finaliseGroups() {
            this.groups.forEach((name, group) -> {
                if (group instanceof OptionGroup.Builder) {
                    OptionGroup.Builder groupBuilder = (OptionGroup.Builder)group;
                    this.category.group(groupBuilder.build());
                }
            });
        }
    }

    public static class BuilderImpl<T>
    implements ConfigClassHandler.Builder<T> {
        private final Class<T> configClass;
        private ResourceLocation id;
        private Function<ConfigClassHandler<T>, ConfigSerializer<T>> serializerFactory;

        public BuilderImpl(Class<T> configClass) {
            this.configClass = configClass;
        }

        @Override
        public ConfigClassHandler.Builder<T> id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        @Override
        public ConfigClassHandler.Builder<T> serializer(Function<ConfigClassHandler<T>, ConfigSerializer<T>> serializerFactory) {
            this.serializerFactory = serializerFactory;
            return this;
        }

        @Override
        public ConfigClassHandler<T> build() {
            Validate.notNull(this.serializerFactory, (String)"serializerFactory must not be null", (Object[])new Object[0]);
            Validate.notNull(this.configClass, (String)"configClass must not be null", (Object[])new Object[0]);
            return new ConfigClassHandlerImpl<T>(this.configClass, this.id, this.serializerFactory);
        }
    }
}

