/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.tab;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.gui.ElementListWidgetExt;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class ListHolderWidget<T extends ElementListWidgetExt<?>>
extends AbstractWidget
implements ContainerEventHandler {
    private final Supplier<ScreenRectangle> dimensions;
    private final T list;

    public ListHolderWidget(Supplier<ScreenRectangle> dimensions, T list) {
        super(0, 0, 100, 0, CommonComponents.EMPTY);
        this.dimensions = dimensions;
        this.list = list;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTick) {
        ScreenRectangle dimensions = this.dimensions.get();
        this.setX(dimensions.left());
        this.setY(dimensions.top());
        this.width = dimensions.width();
        this.height = dimensions.height();
        ((ElementListWidgetExt)((Object)this.list)).updateDimensions(dimensions);
        this.list.render(guiGraphics, mouseX, mouseY, deltaTick);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.list.updateNarration(output);
    }

    public List<? extends GuiEventListener> children() {
        return ImmutableList.of(this.list);
    }

    public T getList() {
        return this.list;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return ((ElementListWidgetExt)((Object)this.list)).mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.list.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return ((ElementListWidgetExt)((Object)this.list)).mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        return ((ElementListWidgetExt)((Object)this.list)).mouseScrolled(mouseX, mouseY, horizontal, vertical);
    }

    public boolean keyPressed(int i, int j, int k) {
        return this.list.keyPressed(i, j, k);
    }

    public boolean charTyped(char c, int i) {
        return this.list.charTyped(c, i);
    }

    public boolean isDragging() {
        return this.list.isDragging();
    }

    public void setDragging(boolean dragging) {
        this.list.setDragging(dragging);
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.list.getFocused();
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        this.list.setFocused(listener);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return this.list.nextFocusPath(event);
    }

    @Nullable
    public ComponentPath getCurrentFocusPath() {
        return this.list.getCurrentFocusPath();
    }
}

