/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories;

import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.compat.config.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.impl.VanillaItemPredicates;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.utils.EndecUtils;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class Accessories {
    @ApiStatus.Internal
    public static GameRules.Key<GameRules.BooleanValue> RULE_KEEP_ACCESSORY_INVENTORY = null;
    public static final String MODID = "accessories";
    private static final AccessoriesConfig CONFIG = AccessoriesConfig.createAndLoad(serializationBuilder -> serializationBuilder.addEndec(Vector2i.class, EndecUtils.VECTOR_2_I_ENDEC));
    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static ResourceLocation of(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static String translationKey(String path) {
        return "accessories." + path;
    }

    public static Component translation(String path) {
        return Component.translatable((String)Accessories.translationKey(path));
    }

    public static AccessoriesConfig config() {
        return CONFIG;
    }

    public static void askPlayerForVariant(ServerPlayer player) {
        Accessories.askPlayerForVariant(player, null);
    }

    public static void askPlayerForVariant(ServerPlayer player, @Nullable LivingEntity targetEntity) {
        AccessoriesNetworking.sendToPlayer(player, ScreenVariantPing.of(targetEntity));
    }

    public static boolean attemptOpenScreenPlayer(ServerPlayer player, AccessoriesMenuVariant variant) {
        HitResult result = ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> e instanceof LivingEntity, (double)player.entityInteractionRange());
        if (!(result instanceof EntityHitResult)) {
            return false;
        }
        EntityHitResult entityHitResult = (EntityHitResult)result;
        Accessories.openAccessoriesMenu((Player)player, variant, (LivingEntity)entityHitResult.getEntity());
        return true;
    }

    public static void openAccessoriesMenu(Player player, AccessoriesMenuVariant variant, @Nullable LivingEntity targetEntity) {
        Accessories.openAccessoriesMenu(player, variant, targetEntity, null);
    }

    public static void openAccessoriesMenu(Player player, AccessoriesMenuVariant variant, @Nullable LivingEntity targetEntity, @Nullable ItemStack carriedStack) {
        TriState result;
        if (targetEntity != null && !player.equals((Object)targetEntity) && !(result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null)).orElse(false)) {
            return;
        }
        AccessoriesInternals.openAccessoriesMenu(player, variant, targetEntity, carriedStack);
    }

    public static void init() {
        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            OwnableEntity ownableEntity;
            boolean isOwnersPet;
            EntityType type = target.getType();
            if (type.is(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) {
                return TriState.FALSE;
            }
            boolean bl = isOwnersPet = target instanceof OwnableEntity && (ownableEntity = (OwnableEntity)target).getOwner() != null && ownableEntity.getOwner().equals((Object)player);
            if (isOwnersPet || type.is(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        });
        ArmorSlotTypes.INSTANCE.init();
        VanillaItemPredicates.init();
    }

    public static void registerCriteria() {
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:equip_accessory", new AccessoryChangedCriterion());
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister("accessories:unequip_accessory", new AccessoryChangedCriterion());
    }
}

