/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AccessoryRegistry {
    private static final Map<Item, Accessory> ACCESSORIES = new HashMap<Item, Accessory>();
    @ApiStatus.Internal
    private static final Accessory DEFAULT = new Accessory(){

        @Override
        public int maxStackSize(ItemStack stack) {
            AccessoryStackSizeComponent data = (AccessoryStackSizeComponent)stack.getOrDefault(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT);
            if (data.useStackSize()) {
                return stack.getMaxStackSize();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.getMaxStackSize());
        }
    };
    @ApiStatus.Internal
    private static final AccessoryNest DEFAULT_NEST = new AccessoryNest(){

        @Override
        public int maxStackSize(ItemStack stack) {
            AccessoryStackSizeComponent data = (AccessoryStackSizeComponent)stack.getOrDefault(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT);
            if (data.useStackSize()) {
                return stack.getMaxStackSize();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.getMaxStackSize());
        }
    };

    public static Map<Item, Accessory> getAllAccessories() {
        return Collections.unmodifiableMap(ACCESSORIES);
    }

    public static void register(Item item, Accessory accessory) {
        ACCESSORIES.put(item, accessory);
    }

    public static Accessory getAccessoryOrDefault(ItemStack stack) {
        Accessory accessory = ACCESSORIES.get(stack.getItem());
        if (accessory == null) {
            accessory = stack.has(AccessoriesDataComponents.NESTED_ACCESSORIES) ? DEFAULT_NEST : DEFAULT;
        }
        return accessory;
    }

    public static Accessory getAccessoryOrDefault(Item item) {
        return ACCESSORIES.getOrDefault(item, DEFAULT);
    }

    @Nullable
    public static Accessory getAccessory(Item item) {
        return ACCESSORIES.get(item);
    }

    public static Accessory defaultAccessory() {
        return DEFAULT;
    }

    public static boolean isDefaultAccessory(ItemStack stack) {
        return AccessoryRegistry.isDefaultAccessory(AccessoryRegistry.getAccessoryOrDefault(stack));
    }

    public static boolean isDefaultAccessory(Accessory accessory) {
        return accessory == DEFAULT || accessory == DEFAULT_NEST;
    }

    public static boolean canEquip(ItemStack stack, SlotReference reference) {
        TriState result = ((CanEquipCallback)CanEquipCallback.EVENT.invoker()).canEquip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoryRegistry.getAccessoryOrDefault(stack).canEquip(stack, reference);
    }

    public static boolean canUnequip(ItemStack stack, SlotReference reference) {
        TriState result = ((CanUnequipCallback)CanUnequipCallback.EVENT.invoker()).canUnequip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoryRegistry.getAccessoryOrDefault(stack).canUnequip(stack, reference);
    }
}

