/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.caching;

import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import java.util.Objects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ItemLikeClassPredicate
extends ItemStackBasedPredicate {
    private final boolean isBlockClass;
    private final Class<? extends ItemLike> clazz;

    public ItemLikeClassPredicate(String name, Class<? extends ItemLike> clazz) {
        super(name);
        this.clazz = clazz;
        this.isBlockClass = clazz.isAssignableFrom(Block.class);
    }

    @Override
    public String extraStringData() {
        return "Class: " + this.clazz.getSimpleName();
    }

    @Override
    public boolean test(ItemStack stack) {
        Item item = stack.getItem();
        if (this.isBlockClass) {
            BlockItem blockItem;
            return item instanceof BlockItem && this.clazz.isInstance((blockItem = (BlockItem)item).getBlock());
        }
        return this.clazz.isInstance(item);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.clazz);
    }

    @Override
    protected boolean isEqual(Object other) {
        ItemLikeClassPredicate itemLikeClassPredicate = (ItemLikeClassPredicate)other;
        return this.clazz.equals(itemLikeClassPredicate.clazz);
    }
}

