/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.compat.GeckoLibCompat;
import io.wispforest.accessories.mixin.client.HumanoidArmorLayerAccessor;
import io.wispforest.accessories.mixin.client.LivingEntityRendererAccessor;
import io.wispforest.accessories.pond.WingsLayerExtension;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class BuiltinAccessoryRenderers {
    public static final AccessoryRenderer ARMOR_RENDERER = new AccessoryRenderer(){

        public <STATE extends LivingEntityRenderState> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<STATE> model, STATE renderState, MultiBufferSource multiBufferSource, int light, float partialTicks) {
            EntityRenderer entityRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)reference.entity());
            if (!(entityRender instanceof LivingEntityRendererAccessor)) {
                return;
            }
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
            if (!(renderState instanceof HumanoidRenderState)) {
                return;
            }
            HumanoidRenderState humanoidRenderState = (HumanoidRenderState)renderState;
            if (!stack.has(DataComponents.EQUIPPABLE)) {
                return;
            }
            EquipmentSlot equipmentSlot = ((Equippable)stack.get(DataComponents.EQUIPPABLE)).slot();
            Optional<RenderLayer> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof HumanoidArmorLayer).findFirst();
            possibleLayer.ifPresent(layer -> BuiltinAccessoryRenderers.rendererArmor((HumanoidArmorLayer)layer, stack, matrices, multiBufferSource, humanoidRenderState, equipmentSlot, light, partialTicks));
        }
    };
    public static final AccessoryRenderer ELYTRA_RENDERER = new AccessoryRenderer(){

        public <STATE extends LivingEntityRenderState> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<STATE> model, STATE renderState, MultiBufferSource multiBufferSource, int light, float partialTicks) {
            EntityRenderer entityRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)reference.entity());
            if (!(entityRender instanceof LivingEntityRendererAccessor)) {
                return;
            }
            LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
            if (!(renderState instanceof HumanoidRenderState)) {
                return;
            }
            HumanoidRenderState humanoidRenderState = (HumanoidRenderState)renderState;
            if (!stack.has(DataComponents.GLIDER)) {
                return;
            }
            Optional<RenderLayer> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof WingsLayer).findFirst();
            possibleLayer.ifPresent(layer -> ((WingsLayerExtension)layer).renderStack(stack, matrices, multiBufferSource, light, humanoidRenderState));
        }
    };

    private static <S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>> void rendererArmor(HumanoidArmorLayer<S, M, A> armorLayer, ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, S renderState, EquipmentSlot equipmentSlot, int light, float partialTicks) {
        HumanoidArmorLayerAccessor armorLayerAccessor = (HumanoidArmorLayerAccessor)armorLayer;
        Object armorModel = armorLayerAccessor.accessories$getArmorModel(renderState, equipmentSlot);
        if (!BuiltinAccessoryRenderers.attemptGeckoRender(stack, poseStack, multiBufferSource, renderState, equipmentSlot, light, partialTicks, (HumanoidModel)armorLayer.getParentModel(), armorModel, armorLayerAccessor::accessories$setPartVisibility)) {
            armorLayerAccessor.accessories$renderArmorPiece(poseStack, multiBufferSource, stack, equipmentSlot, light, armorModel);
        }
    }

    private static <S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>> boolean attemptGeckoRender(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, S renderState, EquipmentSlot equipmentSlot, int light, float partialTicks, M parentModel, A armorModel, BiConsumer<A, EquipmentSlot> partVisibilitySetter) {
        if (!AccessoriesLoaderInternals.isModLoaded("geckolib")) {
            return false;
        }
        return GeckoLibCompat.renderGeckoArmor(poseStack, multiBufferSource, renderState, stack, equipmentSlot, parentModel, armorModel, partialTicks, light, partVisibilitySetter);
    }

    public static void onAddCallback(Item item) {
    }
}

