/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.events.extra;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.IsGazeDisguised;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.events.extra.ShouldFreezeEntity;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ExtraEventHandler {
    private static final LoadingCache<Integer, Map<Integer, TriState>> gazeDisguiseCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(1L)).weakKeys().build(CacheLoader.from(() -> new HashMap()));

    public static int lootingAdjustments(LivingEntity entity, LootContext context, int currentLevel) {
        Entity entity2;
        DamageSource damageSource = (DamageSource)context.getOptionalParameter(LootContextParams.DAMAGE_SOURCE);
        if (damageSource != null && (entity2 = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)entity2;
            AccessoriesCapability capability = AccessoriesCapability.get(entity);
            if (capability != null) {
                for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                    SlotReference reference = entryRef.reference();
                    ItemStack stack = entryRef.stack();
                    Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                    currentLevel += ((LootingAdjustment)LootingAdjustment.EVENT.invoker()).getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                    currentLevel += ((io.wispforest.accessories.api.events.extra.v2.LootingAdjustment)io.wispforest.accessories.api.events.extra.v2.LootingAdjustment.EVENT.invoker()).getLootingAdjustment(stack, reference, targetEntity, context, damageSource, currentLevel);
                    if (!(accessory instanceof io.wispforest.accessories.api.events.extra.v2.LootingAdjustment)) continue;
                    io.wispforest.accessories.api.events.extra.v2.LootingAdjustment lootingAdjustment = (io.wispforest.accessories.api.events.extra.v2.LootingAdjustment)((Object)accessory);
                    currentLevel += lootingAdjustment.getLootingAdjustment(stack, reference, targetEntity, context, damageSource, currentLevel);
                }
            }
        }
        return currentLevel;
    }

    public static int fortuneAdjustment(LootContext context, int currentLevel) {
        LivingEntity livingEntity;
        AccessoriesCapability capability;
        Object object = context.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (object instanceof LivingEntity && (capability = AccessoriesCapability.get(livingEntity = (LivingEntity)object)) != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof FortuneAdjustment) {
                    FortuneAdjustment fortuneAdjustment = (FortuneAdjustment)((Object)accessory);
                    currentLevel += fortuneAdjustment.getFortuneAdjustment(stack, reference, context, currentLevel);
                }
                currentLevel += ((FortuneAdjustment)FortuneAdjustment.EVENT.invoker()).getFortuneAdjustment(stack, reference, context, currentLevel);
            }
        }
        return currentLevel;
    }

    public static TriState isPiglinsNeutral(LivingEntity entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                PiglinNeutralInducer inducer;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof PiglinNeutralInducer && (state = (inducer = (PiglinNeutralInducer)((Object)accessory)).makePiglinsNeutral(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((PiglinNeutralInducer)PiglinNeutralInducer.EVENT.invoker()).makePiglinsNeutral(stack, reference);
                if (state != TriState.DEFAULT) {
                    return state;
                }
                if (!stack.is(ItemTags.PIGLIN_SAFE_ARMOR)) continue;
                return TriState.TRUE;
            }
        }
        return state;
    }

    public static TriState allowWalkingOnSnow(LivingEntity entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                AllowWalkingOnSnow event;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof AllowWalkingOnSnow && (state = (event = (AllowWalkingOnSnow)((Object)accessory)).allowWalkingOnSnow(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((AllowWalkingOnSnow)AllowWalkingOnSnow.EVENT.invoker()).allowWalkingOnSnow(stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        return state;
    }

    public static TriState canFreezeEntity(LivingEntity entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                ShouldFreezeEntity check;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof ShouldFreezeEntity && (state = (check = (ShouldFreezeEntity)((Object)accessory)).shouldFreeze(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((ShouldFreezeEntity)ShouldFreezeEntity.EVENT.invoker()).shouldFreeze(stack, reference);
                if (state != TriState.DEFAULT) {
                    return state;
                }
                if (!stack.is(ItemTags.FREEZE_IMMUNE_WEARABLES)) continue;
                return TriState.FALSE;
            }
        }
        return state;
    }

    public static TriState isGazedBlocked(LivingEntity lookingEntity, LivingEntity targetEntity) {
        if (lookingEntity.getType().is(AccessoriesTags.GAZE_DISGUISED_BLACKLIST)) {
            return TriState.DEFAULT;
        }
        Map cache = (Map)gazeDisguiseCache.getIfPresent((Object)targetEntity.getId());
        if (cache != null && cache.containsKey(lookingEntity.getId())) {
            return (TriState)cache.get(lookingEntity.getId());
        }
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(targetEntity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                IsGazeDisguised masked;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                if (accessory instanceof IsGazeDisguised && (state = (masked = (IsGazeDisguised)((Object)accessory)).isWearDisguise(lookingEntity, stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((IsGazeDisguised)IsGazeDisguised.EVENT.invoker()).isWearDisguise(lookingEntity, stack, reference);
                if (state != TriState.DEFAULT) {
                    return state;
                }
                if (!stack.is(ItemTags.GAZE_DISGUISE_EQUIPMENT)) continue;
                return TriState.TRUE;
            }
        }
        ((Map)gazeDisguiseCache.getUnchecked((Object)targetEntity.getId())).put(lookingEntity.getId(), state);
        return state;
    }
}

