/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.slot.NestedSlotReferenceImpl;
import io.wispforest.accessories.impl.slot.SlotReferenceImpl;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.AccessoryBreak;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public interface SlotReference {
    public static SlotReference of(LivingEntity livingEntity, String slotName, int slot) {
        return new SlotReferenceImpl(livingEntity, slotName, slot);
    }

    public static SlotReference ofNest(LivingEntity livingEntity, String slotName, int initialHolderSlot, List<Integer> innerSlotIndices) {
        return new NestedSlotReferenceImpl(livingEntity, slotName, initialHolderSlot, (List<Integer>)ImmutableList.copyOf(innerSlotIndices));
    }

    public String slotName();

    public LivingEntity entity();

    public int slot();

    default public void breakStack() {
        LivingEntity entity = this.entity();
        AccessoriesNetworking.sendToTrackingAndSelf((Entity)entity, AccessoryBreak.of(this));
        ItemStack currentStack = this.getStack();
        ((AccessoriesLivingEntityExtension)entity).pushEnchantmentContext(currentStack, this);
        EnchantmentHelper.stopLocationBasedEffects((ItemStack)currentStack, (LivingEntity)entity, (EquipmentSlot)AccessoriesInternals.INTERNAL_SLOT);
    }

    default public boolean isValid() {
        AccessoriesCapability capability = this.capability();
        if (capability == null) {
            return false;
        }
        AccessoriesContainer container = capability.getContainers().get(this.slotName());
        if (container == null) {
            return false;
        }
        return this.slot() < container.getSize();
    }

    default public String createSlotPath() {
        return this.slotName().replace(":", "-") + "/" + this.slot();
    }

    @Nullable
    default public SlotType type() {
        return SlotTypeLoader.getSlotType(this.entity().level(), this.slotName());
    }

    @Nullable
    default public AccessoriesCapability capability() {
        return this.entity().accessoriesCapability();
    }

    @Nullable
    default public AccessoriesContainer slotContainer() {
        AccessoriesCapability capability = this.capability();
        if (capability == null) {
            return null;
        }
        return capability.getContainers().get(this.slotName());
    }

    @Nullable
    default public ItemStack getStack() {
        AccessoriesContainer container = this.slotContainer();
        if (container == null) {
            return null;
        }
        return container.getAccessories().getItem(this.slot());
    }

    default public boolean setStack(ItemStack stack) {
        AccessoriesContainer container = this.slotContainer();
        if (container == null) {
            return false;
        }
        container.getAccessories().setItem(this.slot(), stack);
        return true;
    }
}

