/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.screen.AccessoriesScreenTransitionHelper;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.ClientLifecycleEvents;
import io.wispforest.accessories.client.EntityTarget;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.ScreenVariantSelectionScreen;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.compat.config.ScreenType;
import io.wispforest.accessories.compat.config.client.ExtendedConfigScreen;
import io.wispforest.accessories.compat.config.client.Structured;
import io.wispforest.accessories.compat.config.client.components.StructListOptionContainer;
import io.wispforest.accessories.compat.config.client.components.StructOptionContainer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.AccessoriesPlayerOptions;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.PlayerOption;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.shader.GlProgram;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.layers.Layers;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class AccessoriesClient {
    public static KeyMapping OPEN_SCREEN = null;
    public static final ShaderProgram BLIT_SHADER_KEY = new ShaderProgram(Accessories.of("core/fish"), DefaultVertexFormat.BLIT_SCREEN, ShaderDefines.EMPTY);
    public static GlProgram SPECTRUM_PROGRAM;
    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT;
    public static boolean IS_PLAYER_INVISIBLE;
    private static boolean displayUnusedSlotWarning;
    private static final BiFunction<Color, ResourceLocation, RenderType> GUI_TEXTURED;

    public static void initConfigStuff() {
        ConfigScreenProviders.register((String)"accessories", ExtendedConfigScreen.buildFunc(Accessories.config(), (config, factoryRegister) -> {
            factoryRegister.registerFactory(option -> {
                Field field = option.backingField().field();
                if (field.getType() != List.class) {
                    return false;
                }
                Class listType = ReflectionUtils.getTypeArgument((Type)field.getGenericType(), (int)0);
                if (listType == null) {
                    return false;
                }
                return String.class != listType && !NumberReflection.isNumberType((Class)listType);
            }, (uiModel, option) -> {
                StructListOptionContainer layout = new StructListOptionContainer(uiModel, option);
                return new OptionComponentFactory.Result(layout, layout);
            });
            ReflectiveEndecBuilder builder = ((ConfigWrapperAccessor)config).accessories$builder();
            factoryRegister.registerFactory(option -> option.backingField().field().isAnnotationPresent(Structured.class), (model, option) -> {
                Structured annotationData = option.backingField().field().getAnnotation(Structured.class);
                MutableComponent title = Component.translatable((String)("text.config." + option.configName() + ".option." + option.key().asString()));
                FlowLayout titleLayout = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                titleLayout.padding(Insets.of((int)5, (int)5, (int)5, (int)0));
                title = title.copy().withStyle(ChatFormatting.UNDERLINE);
                titleLayout.child((io.wispforest.owo.ui.core.Component)Components.label((Component)title));
                StructOptionContainer component = StructOptionContainer.of(model, option, builder, annotationData.sideBySide());
                titleLayout.child((io.wispforest.owo.ui.core.Component)new SearchAnchorComponent((ParentComponent)titleLayout, option.key(), new Supplier[]{() -> I18n.get((String)("text.config." + option.configName() + ".option." + option.key().asString()), (Object[])new Object[0]), () -> component.parsedValue().toString()}));
                FlowLayout mainLayout = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                mainLayout.child((io.wispforest.owo.ui.core.Component)titleLayout).child((io.wispforest.owo.ui.core.Component)component);
                return new OptionComponentFactory.Result((io.wispforest.owo.ui.core.Component)mainLayout, (OptionValueProvider)component);
            });
        }));
        Accessories.config().clientOptions.subscribeToEquipControl(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.equipControl() == value) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOption.EQUIP_CONTROL, value));
        }));
        Accessories.config().screenOptions.subscribeToShowUnusedSlots(value -> AccessoriesClient.attemptAction(holder -> {
            if (holder.showUnusedSlots() == value.booleanValue()) {
                return;
            }
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOption.UNUSED_PROP, value));
        }));
    }

    public static void init() {
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) {
                return;
            }
            BuiltInRegistries.ITEM.forEach(item -> {
                ItemStack defaultStack = item.getDefaultInstance();
                if ((item instanceof BannerItem || defaultStack.has(DataComponents.GLIDER)) && !AccessoriesRendererRegistry.hasRenderer(item)) {
                    AccessoriesRendererRegistry.registerNoRenderer(item);
                }
            });
            AccessoriesRendererRegistry.onReload();
        });
        SPECTRUM_PROGRAM = new GlProgram(Accessories.of("spectrum_position_tex"), DefaultVertexFormat.POSITION_TEX_COLOR);
        AccessoriesClient.initLayer();
    }

    public static void openScreenFromKey() {
        Minecraft minecraft = Minecraft.getInstance();
        Screen currentScreen = minecraft.screen;
        if (currentScreen instanceof AccessoriesScreenBase) {
            minecraft.setScreen(null);
        } else if (currentScreen == null) {
            AccessoriesClient.attemptToOpenScreen(minecraft.player.isShiftKeyDown() ? EntityTarget.LOOKING_ENTITY : EntityTarget.PLAYER);
        } else {
            LocalPlayer targetEntity = null;
            if (currentScreen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)currentScreen;
                targetEntity = AccessoriesScreenTransitionHelper.getTargetEntity((AbstractContainerScreen<AbstractContainerMenu>)containerScreen);
            }
            if (targetEntity == null) {
                targetEntity = minecraft.player;
            }
            AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
    }

    private static void attemptAction(Consumer<AccessoriesPlayerOptions> consumer) {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (currentPlayer == null || Minecraft.getInstance().level == null) {
            return;
        }
        AccessoriesPlayerOptions options = AccessoriesPlayerOptions.getOptions((Player)currentPlayer);
        if (options != null) {
            consumer.accept(options);
        }
    }

    public static void initalConfigDataSync() {
        LocalPlayer currentPlayer = Minecraft.getInstance().player;
        if (currentPlayer == null || Minecraft.getInstance().level == null) {
            return;
        }
        AccessoriesPlayerOptions options = AccessoriesPlayerOptions.getOptions((Player)currentPlayer);
        if (options == null) {
            return;
        }
        PlayerEquipControl equipControl = Accessories.config().clientOptions.equipControl();
        if (options.equipControl() != equipControl) {
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOption.EQUIP_CONTROL, equipControl));
        }
        boolean showUnusedSlots = Accessories.config().screenOptions.showUnusedSlots();
        if (options.showUnusedSlots() != showUnusedSlots) {
            AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOption.UNUSED_PROP, showUnusedSlots));
        }
    }

    public static boolean attemptToOpenScreen(EntityTarget entityTarget) {
        LivingEntity targetEntity;
        LocalPlayer player = Minecraft.getInstance().player;
        LivingEntity livingEntity = targetEntity = Accessories.config().screenOptions.keybindIgnoresOtherTargets() ? null : AccessoriesScreenTransitionHelper.getTargetEntity(player);
        if (targetEntity == null) {
            EntityHitResult entitResult;
            Entity entity;
            HitResult result;
            if (entityTarget.equals((Object)EntityTarget.PLAYER)) {
                return AccessoriesClient.attemptToOpenScreenFromEntity((LivingEntity)player);
            }
            if (entityTarget.equals((Object)EntityTarget.LOOKING_ENTITY) && (result = ProjectileUtil.getHitResultOnViewVector((Entity)player, e -> e instanceof LivingEntity, (double)player.entityInteractionRange())) instanceof EntityHitResult && (entity = (entitResult = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
                LivingEntity living;
                targetEntity = living = (LivingEntity)entity;
            }
        }
        if (targetEntity != null && !EntitySlotLoader.getEntitySlots(targetEntity).isEmpty()) {
            return AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
        return false;
    }

    public static boolean attemptToOpenScreenFromEntity(LivingEntity targetingEntity) {
        return AccessoriesClient.attemptToOpenScreen(targetingEntity, Accessories.config().screenOptions.selectedScreenType());
    }

    private static boolean attemptToOpenScreen(LivingEntity targetingEntity, ScreenType screenType) {
        AccessoriesMenuVariant selectedVariant;
        LocalPlayer player = Minecraft.getInstance().player;
        if (targetingEntity.equals((Object)player)) {
            Collection<SlotType> slots = AccessoriesCapability.getUsedSlotsFor((Player)player);
            AccessoriesPlayerOptions options = AccessoriesPlayerOptions.getOptions((Player)player);
            if (slots.isEmpty() && !options.showUnusedSlots() && !displayUnusedSlotWarning && !Accessories.config().clientOptions.disableEmptySlotScreenError()) {
                player.displayClientMessage((Component)Component.literal((String)"[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);
                displayUnusedSlotWarning = true;
            }
        }
        if ((selectedVariant = AccessoriesMenuVariant.getVariant(screenType)) != null) {
            AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingEntity, selectedVariant));
        } else {
            Minecraft.getInstance().setScreen((Screen)new ScreenVariantSelectionScreen(variant -> AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingEntity, variant))));
        }
        return true;
    }

    public static void initLayer() {
        AccessoriesScreenTransitionHelper.init();
        Layers.add(Containers::verticalFlow, instance -> {
            instance.aggressivePositioning = true;
            ((FlowLayout)instance.adapter.rootComponent).allowOverflow(true);
            MenuButtonInjection injectionData = AccessoriesScreenTransitionHelper.getInjection((AbstractContainerScreen<AbstractContainerMenu>)((AbstractContainerScreen)instance.screen));
            if (injectionData == null) {
                return;
            }
            ButtonComponent button = (ButtonComponent)Components.button((Component)Component.literal((String)""), btn -> {
                LivingEntity target = AccessoriesScreenTransitionHelper.getTargetEntity((AbstractContainerScreen<AbstractContainerMenu>)((AbstractContainerScreen)instance.screen));
                if (target == null) {
                    target = Minecraft.getInstance().player;
                }
                AccessoriesClient.attemptToOpenScreenFromEntity(target);
            }).renderer((context, btn, delta) -> {
                ButtonComponent.Renderer.VANILLA.draw(context, btn, delta);
                ResourceLocation groupIcon = Accessories.of("container/slot/group/misc");
                Color color = Color.BLACK.interpolate(Color.WHITE, 0.4f);
                context.push().translate(0.0f, 0.0f, 2.0f);
                context.blitSprite(RenderType::guiTexturedOverlay, groupIcon, btn.x() + 2, btn.y() + 2, ((Sizing)btn.horizontalSizing().get()).value - 4, ((Sizing)btn.verticalSizing().get()).value - 4, color.argb());
                context.pop();
            }).tooltip((Component)Component.translatable((String)Accessories.translationKey("open.screen"))).margins(Insets.of((int)1, (int)0, (int)0, (int)1)).sizing(Sizing.fixed((int)(injectionData.mini ? 8 : 12)));
            if (instance.screen instanceof CreativeModeInventoryScreen) {
                ComponentUtils.CreativeScreenExtension extension = (ComponentUtils.CreativeScreenExtension)instance.screen;
                button.visible = extension.getTab().getType().equals((Object)CreativeModeTab.Type.INVENTORY);
                extension.getEvent().register(tab -> {
                    button.visible = tab.getType().equals((Object)CreativeModeTab.Type.INVENTORY);
                });
            }
            ((FlowLayout)instance.adapter.rootComponent).child((io.wispforest.owo.ui.core.Component)button);
            instance.alignComponentToHandledScreenCoordinates((io.wispforest.owo.ui.core.Component)button, injectionData.xOffset(), injectionData.yOffset());
        }, (Class[])AccessoriesScreenTransitionHelper.getScreenClasses());
    }

    static {
        WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
            for (WindowResizeCallback callback : callbacks) {
                callback.onResized(client, window);
            }
        });
        IS_PLAYER_INVISIBLE = false;
        displayUnusedSlotWarning = false;
        GUI_TEXTURED = Util.memoize((color, resourceLocation) -> RenderType.create((String)"gui_textured", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, TriState.FALSE, false)).setShaderState(RenderType.POSITION_TEXTURE_COLOR_SHADER).setWriteMaskState(RenderStateShard.COLOR_WRITE).setTransparencyState(new RenderStateShard.TransparencyStateShard("custom_blend", () -> {
            RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).setDepthTestState(RenderType.LEQUAL_DEPTH_TEST).createCompositeState(false)));
    }

    public static interface WindowResizeCallback {
        public void onResized(Minecraft var1, Window var2);
    }
}

