/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.owo.client.OwoClient;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class GuiGraphicsUtils {
    private static final Function<ResourceLocation, RenderType> SPECTRUM_GUI = Util.memoize(resourceLocation -> RenderType.create((String)"spectrum_gui", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, TriState.FALSE, false)).setShaderState(AccessoriesClient.SPECTRUM_PROGRAM.renderPhaseProgram()).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderType.LEQUAL_DEPTH_TEST).createCompositeState(false)));
    private static final RenderType.CompositeRenderType HSV_GUI = RenderType.create((String)"hsv_gui", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(OwoClient.HSV_PROGRAM.renderPhaseProgram()).setTransparencyState(RenderType.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderType.LEQUAL_DEPTH_TEST).createCompositeState(false));

    public static void drawWithSpectrum(GuiGraphics ctx, int x, int y, int blitOffset, int width, int height, ResourceLocation texture, float alpha) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(texture);
        GuiGraphicsUtils.innerDrawWithSpectrum(ctx, sprite.atlasLocation(), x, x + width, y, y + height, blitOffset, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(GuiGraphics ctx, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, float alpha) {
        GuiGraphicsUtils.innerDrawWithSpectrum(ctx, sprite.atlasLocation(), x, x + width, y, y + height, blitOffset, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(GuiGraphics ctx, int x, int y, int blitOffset, int width, int height, TextureAtlasSprite sprite, Vector4f alphaValues) {
        GuiGraphicsUtils.innerDrawWithSpectrum(ctx, sprite.atlasLocation(), x, x + width, y, y + height, blitOffset, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), alphaValues);
    }

    private static void innerDrawWithSpectrum(GuiGraphics guiGraphics, ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Vector4f alphaValues) {
        OwoUIDrawContext ctx = OwoUIDrawContext.of((GuiGraphics)guiGraphics);
        Matrix4f matrix4f = ctx.pose().last().pose();
        VertexConsumer bufferBuilder = ctx.vertexConsumers().getBuffer(SPECTRUM_GUI.apply(atlasLocation));
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, alphaValues.x);
        bufferBuilder.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV).setColor(0.0f, 1.0f, 1.0f, alphaValues.z);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV).setColor(0.0f, 1.0f, 1.0f, alphaValues.w);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, alphaValues.y);
    }

    public static void drawRectOutlineWithSpectrum(OwoUIDrawContext ctx, int x, int y, int z, int width, int height, float alpha, boolean vertical) {
        GuiGraphicsUtils.drawRectOutlineWithSpectrumWithoutRecord(ctx, x, y, z, width, height, alpha, vertical);
    }

    public static void drawRectOutlineWithSpectrumWithoutRecord(OwoUIDrawContext ctx, int x, int y, int z, int width, int height, float alpha, boolean vertical) {
        GuiGraphicsUtils.innerFill((GuiGraphics)ctx, x, y, x + width, y + 1, 0, alpha, !vertical);
        GuiGraphicsUtils.innerFill((GuiGraphics)ctx, x, y + height - 1, x + width, y + height, 0, alpha, !vertical);
        GuiGraphicsUtils.innerFill((GuiGraphics)ctx, x, y + 1, x + 1, y + height - 1, 0, alpha, vertical);
        GuiGraphicsUtils.innerFill((GuiGraphics)ctx, x + width - 1, y + 1, x + width, y + height - 1, 0, alpha, vertical);
    }

    private static void innerFill(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY, int z, float alpha, boolean vertical) {
        float topValue;
        int i;
        OwoUIDrawContext ctx = OwoUIDrawContext.of((GuiGraphics)guiGraphics);
        if (minX < maxX) {
            i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            i = minY;
            minY = maxY;
            maxY = i;
        }
        VertexConsumer vertexConsumer = ctx.vertexConsumers().getBuffer((RenderType)HSV_GUI);
        float multiplier = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
        float bottomValue = topValue = 1.0f - multiplier;
        Matrix4f matrix4f = ctx.pose().last().pose();
        vertexConsumer.addVertex(matrix4f, (float)minX, (float)minY, (float)z).setColor(topValue, 1.0f, 1.0f, alpha);
        vertexConsumer.addVertex(matrix4f, (float)minX, (float)maxY, (float)z).setColor(vertical ? bottomValue : topValue, 1.0f, 1.0f, alpha);
        vertexConsumer.addVertex(matrix4f, (float)maxX, (float)maxY, (float)z).setColor(bottomValue, 1.0f, 1.0f, alpha);
        vertexConsumer.addVertex(matrix4f, (float)maxX, (float)minY, (float)z).setColor(vertical ? topValue : bottomValue, 1.0f, 1.0f, alpha);
    }
}

