/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.accessories.commands.Key;
import io.wispforest.accessories.commands.RecordArgumentTypeInfo;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class CommandBuilderHelper {
    public Map<String, LiteralArgumentBuilder<CommandSourceStack>> baseCommandPart = new LinkedHashMap<String, LiteralArgumentBuilder<CommandSourceStack>>();
    public BiMap<Key, ArgumentBuilder> commandParts = HashBiMap.create();

    public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        this.generateTrees(context);
        this.baseCommandPart.forEach((string, builder) -> dispatcher.register(builder));
        this.baseCommandPart.clear();
        this.commandParts.clear();
    }

    protected abstract void generateTrees(CommandBuildContext var1);

    public abstract void registerArgumentTypes(ArgumentRegistration var1);

    public <T> CommandArgumentHolder<T> argumentHolder(String name, ArgumentType<?> type, CommandArgumentGetter<T> getter) {
        return new CommandArgumentHolder<T>(name, type, getter);
    }

    public <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> getOrCreateNode(String key, CommandArgumentHolder<?> ... argumentsParts) {
        ArgumentBuilder<CommandSourceStack, T> baseBuilder = this.getOrCreateNode(((String)key).split("/"));
        RequiredArgumentBuilder outerArg = null;
        RequiredArgumentBuilder currentArg = null;
        ArrayList<Pair> args = new ArrayList<Pair>();
        for (CommandArgumentHolder arg : Lists.reverse(List.of(argumentsParts))) {
            if (currentArg == null) {
                outerArg = currentArg = arg.builder();
            } else {
                currentArg = (RequiredArgumentBuilder)arg.builder().then(currentArg);
            }
            args.add(Pair.of((Object)arg.name(), (Object)currentArg));
        }
        for (Pair pair : Lists.reverse(args)) {
            key = (String)key + "/" + (String)pair.first();
            Key argKey = new Key((String)key);
            this.commandParts.put((Object)argKey, (Object)((ArgumentBuilder)pair.second()));
        }
        baseBuilder.then(currentArg);
        return outerArg;
    }

    public <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> getOrCreateNode(String key) {
        return this.getOrCreateNode(new Key(key));
    }

    public <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> getOrCreateNode(String ... keyParts) {
        return this.getOrCreateNode(new Key(keyParts));
    }

    public <T extends ArgumentBuilder<CommandSourceStack, T>> ArgumentBuilder<CommandSourceStack, T> getOrCreateNode(Key key) {
        LiteralArgumentBuilder builder;
        if (this.commandParts.containsKey((Object)key)) {
            return (ArgumentBuilder)this.commandParts.get((Object)key);
        }
        Key parentKey = key.parent();
        if (parentKey == null) {
            LiteralArgumentBuilder baseBuilder = Commands.literal((String)key.topPath());
            this.baseCommandPart.put(key.topPath(), (LiteralArgumentBuilder<CommandSourceStack>)baseBuilder);
            builder = baseBuilder;
        } else {
            ArgumentBuilder<CommandSourceStack, T> parentBuilder = this.getOrCreateNode(parentKey);
            builder = Commands.literal((String)key.topPath());
            parentBuilder.then((ArgumentBuilder)builder);
        }
        this.commandParts.put((Object)key, (Object)builder);
        return builder;
    }

    public <T extends ArgumentBuilder<CommandSourceStack, T>> void updateParent(ArgumentBuilder builder) {
        Key key = (Key)this.commandParts.inverse().get((Object)builder);
        Key parentKey = key.parent();
        if (parentKey == null) {
            return;
        }
        ArgumentBuilder parentBuilder = (ArgumentBuilder)this.commandParts.get((Object)parentKey);
        parentBuilder.then(builder);
        this.updateParent(parentBuilder);
    }

    public <T1> void optionalArgExectution(String key, CommandArgumentHolder<T1> arg1, CommandFunction1<@Nullable T1> commandExecution) {
        this.optionalArgExectution(new Key(key), arg1, commandExecution);
    }

    public <T1> void optionalArgExectution(Key key, CommandArgumentHolder<T1> arg1, CommandFunction1<@Nullable T1> commandExecution) {
        this.updateParent(this.getOrCreateNode(key).then(arg1.builder().executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, arg1.getArgument((CommandContext<CommandSourceStack>)ctx)))).executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, null)));
    }

    public <T1> void requiredArgExectution(String key, CommandArgumentHolder<T1> arg1, CommandFunction1<T1> commandExecution) {
        this.requiredArgExectution(new Key(key), arg1, commandExecution);
    }

    public <T1> void requiredArgExectution(Key key, CommandArgumentHolder<T1> arg1, CommandFunction1<T1> commandExecution) {
        this.updateParent(this.getOrCreateNode(key).then(arg1.builder().executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, arg1.getArgument((CommandContext<CommandSourceStack>)ctx)))));
    }

    public <T1, T2> void requiredArgExectution(String key, CommandArgumentHolder<T1> arg1, CommandArgumentHolder<T2> arg2, CommandFunction2<T1, T2> commandExecution) {
        this.requiredArgExectution(new Key(key), arg1, arg2, commandExecution);
    }

    public <T1, T2> void requiredArgExectution(Key key, CommandArgumentHolder<T1> arg1, CommandArgumentHolder<T2> arg2, CommandFunction2<T1, T2> commandExecution) {
        this.updateParent(this.getOrCreateNode(key).then(arg1.builder().then(arg2.builder().executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, arg1.getArgument((CommandContext<CommandSourceStack>)ctx), arg2.getArgument((CommandContext<CommandSourceStack>)ctx))))));
    }

    public <T1, T2, T3> void requiredArgExectution(String key, CommandArgumentHolder<T1> arg1, CommandArgumentHolder<T2> arg2, CommandArgumentHolder<T3> arg3, CommandFunction3<T1, T2, T3> commandExecution) {
        this.requiredArgExectution(new Key(key), arg1, arg2, arg3, commandExecution);
    }

    public <T1, T2, T3> void requiredArgExectution(Key key, CommandArgumentHolder<T1> arg1, CommandArgumentHolder<T2> arg2, CommandArgumentHolder<T3> arg3, CommandFunction3<T1, T2, T3> commandExecution) {
        this.updateParent(this.getOrCreateNode(key).then(arg1.builder().then(arg2.builder().then(arg3.builder().executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, arg1.getArgument((CommandContext<CommandSourceStack>)ctx), arg2.getArgument((CommandContext<CommandSourceStack>)ctx), arg3.getArgument((CommandContext<CommandSourceStack>)ctx)))))));
    }

    public void requiredExectutionBranched(String key, List<String> literalBranches, CommandFunction1<String> commandExecution) {
        this.requiredExectutionBranched(new Key(key), literalBranches, commandExecution);
    }

    public void requiredExectutionBranched(Key key, List<String> literalBranches, CommandFunction1<String> commandExecution) {
        ArgumentBuilder builder = this.getOrCreateNode(key);
        for (String branch : literalBranches) {
            builder.then(Commands.literal((String)branch).executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, branch)));
        }
        this.updateParent(builder);
    }

    public <T1> void requiredArgExectutionBranched(String key, List<String> literalBranches, CommandArgumentHolder<T1> arg1, CommandFunction2<String, T1> commandExecution) {
        this.requiredArgExectutionBranched(new Key(key), literalBranches, arg1, commandExecution);
    }

    public <T1> void requiredArgExectutionBranched(Key key, List<String> literalBranches, CommandArgumentHolder<T1> arg1, CommandFunction2<String, T1> commandExecution) {
        ArgumentBuilder builder = this.getOrCreateNode(key);
        for (String branch : literalBranches) {
            builder.then(Commands.literal((String)branch).then(arg1.builder().executes(ctx -> commandExecution.execute((CommandContext<CommandSourceStack>)ctx, branch, arg1.getArgument((CommandContext<CommandSourceStack>)ctx)))));
        }
        this.updateParent(builder);
    }

    public record CommandArgumentHolder<T>(String name, ArgumentType<?> type, CommandArgumentGetter<T> getter) {
        public static <T> CommandArgumentHolder<T> of(String name, ArgumentType<?> type, CommandArgumentGetter<T> getter) {
            return new CommandArgumentHolder<T>(name, type, getter);
        }

        public RequiredArgumentBuilder<CommandSourceStack, ?> builder() {
            return Commands.argument((String)this.name, this.type);
        }

        public T getArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
            return this.getter.get(ctx, this.name);
        }
    }

    public static interface CommandArgumentGetter<T> {
        public T get(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;
    }

    public static interface CommandFunction1<T1> {
        public int execute(CommandContext<CommandSourceStack> var1, T1 var2) throws CommandSyntaxException;
    }

    public static interface CommandFunction2<T1, T2> {
        public int execute(CommandContext<CommandSourceStack> var1, T1 var2, T2 var3) throws CommandSyntaxException;
    }

    public static interface CommandFunction3<T1, T2, T3> {
        public int execute(CommandContext<CommandSourceStack> var1, T1 var2, T2 var3, T3 var4) throws CommandSyntaxException;
    }

    public static interface ArgumentRegistration {
        public <A extends ArgumentType<?>, T> RecordArgumentTypeInfo<A, T> register(ResourceLocation var1, Class<A> var2, RecordArgumentTypeInfo<A, T> var3);
    }

    public static interface CommandFunction6<T1, T2, T3, T4, T5, T6> {
        public int execute(CommandContext<CommandSourceStack> var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6, T6 var7) throws CommandSyntaxException;
    }

    public static interface CommandFunction5<T1, T2, T3, T4, T5> {
        public int execute(CommandContext<CommandSourceStack> var1, T1 var2, T2 var3, T3 var4, T4 var5, T5 var6) throws CommandSyntaxException;
    }

    public static interface CommandFunction4<T1, T2, T3, T4> {
        public int execute(CommandContext<CommandSourceStack> var1, T1 var2, T2 var3, T3 var4, T4 var5) throws CommandSyntaxException;
    }

    public static interface CommandFunction {
        public int execute(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

