/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesContainerImpl
implements AccessoriesContainer,
InstanceEndec,
ContainerListener {
    protected AccessoriesCapability capability;
    private String slotName;
    protected final Map<ResourceLocation, AttributeModifier> modifiers = new HashMap<ResourceLocation, AttributeModifier>();
    protected final Set<AttributeModifier> persistentModifiers = new HashSet<AttributeModifier>();
    protected final Set<AttributeModifier> cachedModifiers = new HashSet<AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    @Nullable
    private Integer baseSize;
    private List<Boolean> renderOptions;
    private ExpandedSimpleContainer accessories;
    private ExpandedSimpleContainer cosmeticAccessories;
    private boolean update = false;
    private boolean resizingUpdate = false;
    protected boolean containerListenerLock = false;
    public static final KeyedEndec<String> SLOT_NAME_KEY = Endec.STRING.keyed("slot_name", (Object)"UNKNOWN");
    public static final KeyedEndec<Integer> BASE_SIZE_KEY = Endec.INT.keyed("base_size", () -> null);
    public static final KeyedEndec<Integer> CURRENT_SIZE_KEY = Endec.INT.keyed("current_size", (Object)0);
    public static final KeyedEndec<List<Boolean>> RENDER_OPTIONS_KEY = Endec.BOOLEAN.listOf().keyed("render_options", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("modifiers", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> PERSISTENT_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("persistent_modifiers", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> CACHED_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("cached_modifiers", ArrayList::new);
    public static final KeyedEndec<ListTag> ITEMS_KEY = EndecUtils.NBT_LIST.keyed("items", ListTag::new);
    public static final KeyedEndec<ListTag> COSMETICS_KEY = EndecUtils.NBT_LIST.keyed("cosmetics", ListTag::new);

    public AccessoriesContainerImpl(AccessoriesCapability capability, SlotType slotType) {
        this.capability = capability;
        this.slotName = slotType.name();
        this.baseSize = slotType.amount();
        this.accessories = new ExpandedSimpleContainer(this, this.baseSize, "accessories", false);
        this.cosmeticAccessories = new ExpandedSimpleContainer(this, this.baseSize, "cosmetic_accessories", false);
        this.renderOptions = this.getWithSize(this.baseSize, new ArrayList(), true);
    }

    public void containerChanged(Container container) {
        if (this.containerListenerLock) {
            return;
        }
        AccessoriesHolderLookupCache cache = AccessoriesHolderImpl.getHolder(this.capability()).getLookupCache();
        if (cache != null) {
            cache.clearContainerCache(this.slotName);
        }
        if (((ExpandedSimpleContainer)container).name().contains("cosmetic")) {
            return;
        }
        this.markChanged();
        this.update();
    }

    @Nullable
    public Integer getBaseSize() {
        return this.baseSize;
    }

    @Override
    public void markChanged(boolean resizingUpdate) {
        this.update = true;
        this.resizingUpdate = resizingUpdate;
        if (this.capability.entity().level().isClientSide) {
            return;
        }
        Map<AccessoriesContainer, Boolean> inv = AccessoriesHolderImpl.getHolder((AccessoriesCapability)this.capability).containersRequiringUpdates;
        inv.remove(this);
        inv.put(this, resizingUpdate);
    }

    @Override
    public boolean hasChanged() {
        return this.update;
    }

    @Override
    public void update() {
        double size;
        boolean hasChangeOccurred;
        boolean bl = hasChangeOccurred = !this.resizingUpdate;
        if (!this.update) {
            return;
        }
        this.update = false;
        if (this.capability.entity().level().isClientSide) {
            return;
        }
        SlotType slotType = this.slotType();
        if (this.baseSize == null) {
            this.baseSize = 0;
        }
        if (slotType != null && this.baseSize.intValue() != slotType.amount()) {
            this.baseSize = slotType.amount();
            hasChangeOccurred = true;
        }
        double baseSize = this.baseSize.intValue();
        if (ExtraSlotTypeProperties.getProperty(this.slotName, false).allowResizing()) {
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADD_VALUE)) {
                baseSize += modifier.amount();
            }
            size = baseSize;
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                size += (double)this.baseSize.intValue() * modifier.amount();
            }
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                size *= modifier.amount();
            }
        } else {
            size = baseSize;
        }
        AccessoriesHolderImpl holder = AccessoriesHolderImpl.getHolder(this.capability());
        int currentSize = (int)Math.round(size);
        if (currentSize != this.accessories.getContainerSize()) {
            hasChangeOccurred = true;
            ArrayList<Pair> invalidAccessories = new ArrayList<Pair>();
            ArrayList<ItemStack> invalidStacks = new ArrayList<ItemStack>();
            this.containerListenerLock = true;
            ExpandedSimpleContainer newAccessories = new ExpandedSimpleContainer(this, currentSize, "accessories");
            ExpandedSimpleContainer newCosmetics = new ExpandedSimpleContainer(this, currentSize, "cosmetic_accessories");
            for (int i = 0; i < this.accessories.getContainerSize(); ++i) {
                if (i < newAccessories.getContainerSize()) {
                    newAccessories.setItem(i, this.accessories.getItem(i));
                    newCosmetics.setItem(i, this.cosmeticAccessories.getItem(i));
                    continue;
                }
                invalidAccessories.add(Pair.of((Object)i, (Object)this.accessories.getItem(i)));
                invalidStacks.add(this.cosmeticAccessories.getItem(i));
            }
            this.containerListenerLock = false;
            newAccessories.copyPrev(this.accessories);
            newCosmetics.copyPrev(this.cosmeticAccessories);
            this.accessories = newAccessories;
            this.cosmeticAccessories = newCosmetics;
            this.renderOptions = this.getWithSize(currentSize, this.renderOptions, true);
            LivingEntity livingEntity = this.capability.entity();
            for (Pair invalidAccessory : invalidAccessories) {
                Integer index = (Integer)invalidAccessory.getFirst();
                ItemStack invalidStack = (ItemStack)invalidAccessory.getSecond();
                if (invalidStack.isEmpty()) continue;
                SlotReference slotReference = SlotReference.of(livingEntity, this.slotName, index);
                AttributeUtils.removeTransientAttributeModifiers(livingEntity, AccessoryAttributeLogic.getAttributeModifiers(invalidStack, slotReference));
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(invalidStack);
                if (accessory != null) {
                    accessory.onUnequip(invalidStack, slotReference);
                }
                invalidStacks.add(invalidStack);
            }
            holder.invalidStacks.addAll(invalidStacks);
            if (this.update) {
                this.capability.updateContainers();
            }
        }
        if (!hasChangeOccurred) {
            Map<AccessoriesContainer, Boolean> inv = holder.containersRequiringUpdates;
            inv.remove(this);
        } else {
            AccessoriesHolderLookupCache cache = holder.getLookupCache();
            if (cache != null) {
                cache.clearContainerCache(this.slotName);
            }
        }
    }

    @Override
    public int getSize() {
        this.update();
        return this.accessories.getContainerSize();
    }

    @Override
    public String getSlotName() {
        return this.slotName;
    }

    @Override
    public AccessoriesCapability capability() {
        return this.capability;
    }

    @Override
    public List<Boolean> renderOptions() {
        this.update();
        return this.renderOptions;
    }

    @Override
    public ExpandedSimpleContainer getAccessories() {
        this.update();
        return this.accessories;
    }

    @Override
    public ExpandedSimpleContainer getCosmeticAccessories() {
        this.update();
        return this.cosmeticAccessories;
    }

    @Override
    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Set<AttributeModifier> getCachedModifiers() {
        return this.cachedModifiers;
    }

    @Override
    public Collection<AttributeModifier> getModifiersForOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.id(), modifier);
        this.getModifiersForOperation(modifier.operation()).add(modifier);
        this.markChanged();
    }

    @Override
    public void addPersistentModifier(AttributeModifier modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public boolean hasModifier(ResourceLocation location) {
        return this.modifiers.containsKey(location);
    }

    @Override
    public void removeModifier(ResourceLocation location) {
        AttributeModifier modifier = this.modifiers.remove(location);
        if (modifier == null) {
            return;
        }
        this.persistentModifiers.remove(modifier);
        this.getModifiersForOperation(modifier.operation()).remove(modifier);
        this.markChanged();
    }

    @Override
    public void clearModifiers() {
        this.getModifiers().keySet().iterator().forEachRemaining(this::removeModifier);
    }

    @Override
    public void removeCachedModifiers(AttributeModifier modifier) {
        this.cachedModifiers.remove(modifier);
    }

    @Override
    public void clearCachedModifiers() {
        this.cachedModifiers.forEach(cachedModifier -> this.removeModifier(cachedModifier.id()));
        this.cachedModifiers.clear();
    }

    public void copyFrom(AccessoriesContainerImpl other) {
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.values().forEach(this::addTransientModifier);
        other.persistentModifiers.forEach(this::addPersistentModifier);
        this.update();
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        this.write(carrier, ctx, false);
    }

    public void write(MapCarrier carrier, SerializationContext ctx, boolean sync) {
        RegistryAccess registryAccess = ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager();
        carrier.put(SLOT_NAME_KEY, (Object)this.slotName);
        carrier.putIfNotNull(ctx, BASE_SIZE_KEY, (Object)this.baseSize);
        carrier.put(RENDER_OPTIONS_KEY, this.renderOptions);
        if (!sync || this.accessories.wasNewlyConstructed()) {
            carrier.put(CURRENT_SIZE_KEY, (Object)this.accessories.getContainerSize());
            carrier.put(ITEMS_KEY, (Object)this.accessories.createTag((HolderLookup.Provider)registryAccess));
            carrier.put(COSMETICS_KEY, (Object)this.cosmeticAccessories.createTag((HolderLookup.Provider)registryAccess));
        }
        if (sync) {
            if (!this.modifiers.isEmpty()) {
                ArrayList modifiersTag = new ArrayList();
                this.modifiers.values().forEach(modifier -> modifiersTag.add(modifier.save()));
                carrier.put(MODIFIERS_KEY, modifiersTag);
            }
        } else {
            if (!this.persistentModifiers.isEmpty()) {
                ArrayList persistentTag = new ArrayList();
                this.persistentModifiers.forEach(modifier -> persistentTag.add(modifier.save()));
                carrier.put(PERSISTENT_MODIFIERS_KEY, persistentTag);
            }
            if (!this.modifiers.isEmpty()) {
                ArrayList cachedTag = new ArrayList();
                this.modifiers.values().forEach(modifier -> {
                    if (this.persistentModifiers.contains(modifier)) {
                        return;
                    }
                    cachedTag.add(modifier.save());
                });
                carrier.put(CACHED_MODIFIERS_KEY, cachedTag);
            }
        }
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.read(carrier, ctx, false);
    }

    public void read(MapCarrier carrier, SerializationContext ctx, boolean sync) {
        RegistryAccess registryAccess = ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager();
        EndecUtils.dfuKeysCarrier(carrier, Map.of("SlotName", "slot_name", "BaseSize", "base_size", "CurrentSize", "current_size", "RenderOptions", "render_options", "Modifiers", "modifiers", "PersistentModifiers", "persistent_modifiers", "CachedModifiers", "cached_modifiers", "Items", "items", "Cosmetics", "cosmetics"));
        this.slotName = (String)carrier.get(SLOT_NAME_KEY);
        this.baseSize = (Integer)carrier.get(BASE_SIZE_KEY);
        if (sync) {
            this.modifiers.clear();
            this.persistentModifiers.clear();
            this.modifiersByOperation.clear();
            if (carrier.has(MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(MODIFIERS_KEY);
                for (CompoundTag compoundTag : persistentTag) {
                    AttributeModifier modifier = AttributeModifier.load((CompoundTag)compoundTag);
                    if (modifier == null) continue;
                    this.addTransientModifier(modifier);
                }
            }
        } else {
            AttributeModifier modifier;
            if (carrier.has(PERSISTENT_MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(PERSISTENT_MODIFIERS_KEY);
                for (CompoundTag compoundTag : persistentTag) {
                    modifier = AttributeModifier.load((CompoundTag)compoundTag);
                    if (modifier == null) continue;
                    this.addPersistentModifier(modifier);
                }
            }
            if (carrier.has(CACHED_MODIFIERS_KEY)) {
                List cachedTag = (List)carrier.get(CACHED_MODIFIERS_KEY);
                for (CompoundTag compoundTag : cachedTag) {
                    modifier = AttributeModifier.load((CompoundTag)compoundTag);
                    if (modifier == null) continue;
                    this.cachedModifiers.add(modifier);
                    this.addTransientModifier(modifier);
                }
                this.update();
            }
        }
        if (carrier.has(CURRENT_SIZE_KEY)) {
            Integer currentSize = (Integer)carrier.get(CURRENT_SIZE_KEY);
            List sentOptions = (List)carrier.get(RENDER_OPTIONS_KEY);
            this.renderOptions = this.getWithSize(currentSize, sentOptions, true);
            if (this.accessories.getContainerSize() != currentSize.intValue()) {
                this.accessories = new ExpandedSimpleContainer(this, currentSize, "accessories");
                this.cosmeticAccessories = new ExpandedSimpleContainer(this, currentSize, "cosmetic_accessories");
            }
            this.accessories.fromTag((ListTag)carrier.get(ITEMS_KEY), (HolderLookup.Provider)registryAccess);
            this.cosmeticAccessories.fromTag((ListTag)carrier.get(COSMETICS_KEY), (HolderLookup.Provider)registryAccess);
        } else {
            this.renderOptions = (List)carrier.get(RENDER_OPTIONS_KEY);
        }
    }

    private <T> List<T> getWithSize(int size, List<T> list, T defaultValue) {
        ArrayList<T> sizedList = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            T value = i < list.size() ? list.get(i) : defaultValue;
            sizedList.add(value);
        }
        return sizedList;
    }

    public static SimpleContainer readContainer(MapCarrier carrier, SerializationContext ctx, KeyedEndec<ListTag> key) {
        return AccessoriesContainerImpl.readContainers(carrier, ctx, key).get(0);
    }

    @SafeVarargs
    public static List<SimpleContainer> readContainers(MapCarrier carrier, SerializationContext ctx, KeyedEndec<ListTag> ... keys) {
        ArrayList<SimpleContainer> containers = new ArrayList<SimpleContainer>();
        RegistryAccess registryAccess = ((RegistriesAttribute)ctx.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager();
        for (KeyedEndec<ListTag> key : keys) {
            SimpleContainer stacks = new SimpleContainer(new ItemStack[0]);
            if (carrier.has(key)) {
                stacks.fromTag((ListTag)carrier.get(key), (HolderLookup.Provider)registryAccess);
            }
            containers.add(stacks);
        }
        return containers;
    }

    public static SimpleContainer copyContainerList(SimpleContainer container) {
        return new SimpleContainer((ItemStack[])container.getItems().toArray(ItemStack[]::new));
    }
}

