/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesPlayerOptions;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesHolderImpl
implements InstanceEndec {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MapCarrier EMPTY = new NbtMapCarrier(new CompoundTag());
    private final Map<String, AccessoriesContainer> slotContainers = new LinkedHashMap<String, AccessoriesContainer>();
    public final List<ItemStack> invalidStacks = new ArrayList<ItemStack>();
    protected final Map<AccessoriesContainer, Boolean> containersRequiringUpdates = new HashMap<AccessoriesContainer, Boolean>();
    private MapCarrier carrier;
    protected boolean loadedFromTag = false;
    @Nullable
    private Map<String, AccessoriesContainer> validSlotContainers = null;
    @Nullable
    public AccessoriesHolderLookupCache lookupCache = null;
    private static final KeyedEndec<Map<String, AccessoriesContainer>> CONTAINERS_KEY = NbtEndec.COMPOUND.xmapWithContext((ctx, containersMap) -> {
        LivingEntity entity = ((EntityAttribute)ctx.requireAttributeValue(EntityAttribute.ENTITY)).livingEntity();
        Map<String, AccessoriesContainer> slotContainers = ((ContainersAttribute)ctx.requireAttributeValue(ContainersAttribute.CONTAINERS)).slotContainers();
        List<ItemStack> invalidStacks = ((InvalidStacksAttribute)ctx.requireAttributeValue(InvalidStacksAttribute.INVALID_STACKS)).invalidStacks();
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        for (String key : containersMap.getAllKeys()) {
            int i;
            CompoundTag containerElement = containersMap.getCompound(key);
            if (containerElement.isEmpty()) continue;
            if (slots.containsKey(key)) {
                AccessoriesContainer container = slotContainers.get(key);
                SimpleContainer prevAccessories = AccessoriesContainerImpl.copyContainerList(container.getAccessories());
                SimpleContainer prevCosmetics = AccessoriesContainerImpl.copyContainerList(container.getCosmeticAccessories());
                ((AccessoriesContainerImpl)container).read(new NbtMapCarrier(containerElement), (SerializationContext)ctx);
                if (prevAccessories.getContainerSize() <= container.getSize()) continue;
                for (i = container.getSize() - 1; i < prevAccessories.getContainerSize(); ++i) {
                    ItemStack prevCosmetic;
                    ItemStack prevStack = prevAccessories.getItem(i);
                    if (!prevStack.isEmpty()) {
                        invalidStacks.add(prevStack);
                    }
                    if ((prevCosmetic = prevCosmetics.getItem(i)).isEmpty()) continue;
                    invalidStacks.add(prevCosmetic);
                }
                continue;
            }
            List<SimpleContainer> containers = AccessoriesContainerImpl.readContainers(new NbtMapCarrier(containerElement), ctx, AccessoriesContainerImpl.COSMETICS_KEY, AccessoriesContainerImpl.ITEMS_KEY);
            for (SimpleContainer simpleContainer : containers) {
                for (i = 0; i < simpleContainer.getContainerSize(); ++i) {
                    ItemStack stack = simpleContainer.getItem(i);
                    if (stack.isEmpty()) continue;
                    invalidStacks.add(stack);
                }
            }
        }
        return slotContainers;
    }, (ctx, containers) -> {
        CompoundTag containerMap = new CompoundTag();
        containers.forEach((s, container) -> containerMap.put(s, (Tag)((NbtMapCarrier)Util.make((Object)NbtMapCarrier.of(), innerCarrier -> ((AccessoriesContainerImpl)container).write((MapCarrier)innerCarrier, (SerializationContext)ctx))).compoundTag()));
        return containerMap;
    }).keyed("accessories_containers", HashMap::new);

    public static AccessoriesHolderImpl of() {
        AccessoriesHolderImpl holder = new AccessoriesHolderImpl();
        holder.loadedFromTag = true;
        holder.carrier = EMPTY;
        return holder;
    }

    @Nullable
    public static AccessoriesHolderImpl getHolder(LivingEntity livingEntity) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            return null;
        }
        return AccessoriesHolderImpl.getHolder(capability);
    }

    public static AccessoriesHolderImpl getHolder(AccessoriesCapability capability) {
        LivingEntity entity = capability.entity();
        AccessoriesHolderImpl holder = AccessoriesInternals.getHolder(entity);
        if (holder.loadedFromTag) {
            capability.reset(true);
        }
        if (holder.getSlotContainers().size() != EntitySlotLoader.getEntitySlots(entity).size()) {
            holder.init(capability);
        }
        return holder;
    }

    @ApiStatus.Internal
    protected Map<String, AccessoriesContainer> getAllSlotContainers() {
        return this.slotContainers;
    }

    public void setValidTypes(Set<String> validTypes) {
        ImmutableMap.Builder validSlotContainers = ImmutableMap.builder();
        this.slotContainers.forEach((string, container) -> {
            if (validTypes.contains(container.getSlotName())) {
                validSlotContainers.put(string, container);
            }
        });
        this.validSlotContainers = validSlotContainers.build();
        if (this.lookupCache == null) {
            this.lookupCache = new AccessoriesHolderLookupCache(this);
        }
        this.lookupCache.clearCache();
    }

    @ApiStatus.Internal
    public Map<String, AccessoriesContainer> getSlotContainers() {
        return this.validSlotContainers != null ? this.validSlotContainers : this.getAllSlotContainers();
    }

    @Nullable
    public AccessoriesHolderLookupCache getLookupCache() {
        return null;
    }

    public void init(AccessoriesCapability capability) {
        LivingEntity livingEntity = capability.entity();
        Map<String, SlotType> entitySlots = EntitySlotLoader.getEntitySlots(livingEntity);
        if (livingEntity instanceof Player && entitySlots.isEmpty()) {
            LOGGER.warn("It seems the given player has no slots bound to it within a init call, is that desired?");
        }
        this.validSlotContainers = null;
        if (this.loadedFromTag) {
            entitySlots.forEach((s, slotType) -> this.slotContainers.putIfAbsent((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
            SerializationContext ctx = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new EntityAttribute(livingEntity), RegistriesAttribute.of((RegistryAccess)livingEntity.registryAccess())});
            this.read(capability, livingEntity, this.carrier, ctx);
        } else {
            entitySlots.forEach((s, slotType) -> this.slotContainers.put((String)s, new AccessoriesContainerImpl(capability, (SlotType)slotType)));
        }
        this.setValidTypes(entitySlots.keySet());
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        if (this.slotContainers.isEmpty()) {
            return;
        }
        carrier.put(ctx, CONTAINERS_KEY, this.slotContainers);
    }

    public void read(LivingEntity entity, MapCarrier carrier, SerializationContext ctx) {
        this.read(entity.accessoriesCapability(), entity, carrier, ctx);
    }

    public void read(AccessoriesCapability capability, LivingEntity entity, MapCarrier carrier, SerializationContext ctx) {
        this.loadedFromTag = false;
        EndecUtils.dfuKeysCarrier(carrier, Map.of("AccessoriesContainers", "accessories_containers", "CosmeticsShown", "cosmetics_shown", "LinesShown", "lines_shown", "EquipControl", "equip_control"));
        carrier.getWithErrors(ctx.withAttributes(new SerializationAttribute.Instance[]{new ContainersAttribute(this.slotContainers), new InvalidStacksAttribute(this.invalidStacks)}), CONTAINERS_KEY);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            AccessoriesPlayerOptions options = AccessoriesPlayerOptions.getOptions((Player)player);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.EQUIP_CONTROL_KEY, AccessoriesPlayerOptions::equipControl);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.COLUMN_AMOUNT_KEY, AccessoriesPlayerOptions::columnAmount);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.WIDGET_TYPE_KEY, AccessoriesPlayerOptions::widgetType);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.MAIN_WIDGET_POSITION, AccessoriesPlayerOptions::mainWidgetPosition);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.SIDE_WIDGET_POSITION, AccessoriesPlayerOptions::sideWidgetPosition);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.SHOW_COSMETICS_KEY, AccessoriesPlayerOptions::showCosmetics);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.SHOW_UNUSED_SLOTS_KEY, AccessoriesPlayerOptions::showUnusedSlots);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.SHOW_GROUP_FILTER, AccessoriesPlayerOptions::showGroupFilter);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.IS_GROUP_FILTERS_OPEN_KEY, AccessoriesPlayerOptions::isGroupFiltersOpen);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.FILTERED_GROUPS_KEY, AccessoriesPlayerOptions::filteredGroups);
            AccessoriesHolderImpl.setIfPresent(carrier, options, AccessoriesPlayerOptions.SHOW_CRAFTING_GRID, AccessoriesPlayerOptions::showCraftingGrid);
        }
        capability.clearCachedSlotModifiers();
        this.carrier = EMPTY;
        AccessoriesHolderLookupCache cache = this.getLookupCache();
        if (cache != null) {
            cache.clearCache();
        }
    }

    private static <F> void setIfPresent(MapCarrier carrier, AccessoriesPlayerOptions options, KeyedEndec<F> keyedEndec, BiConsumer<AccessoriesPlayerOptions, F> consumer) {
        if (carrier.has(keyedEndec)) {
            consumer.accept(options, carrier.get(keyedEndec));
        }
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext context) {
        this.loadedFromTag = true;
        this.carrier = carrier;
    }

    private record EntityAttribute(LivingEntity livingEntity) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<EntityAttribute> ENTITY = SerializationAttribute.withValue((String)"entity");

        public SerializationAttribute attribute() {
            return ENTITY;
        }

        public Object value() {
            return this;
        }
    }

    private record ContainersAttribute(Map<String, AccessoriesContainer> slotContainers) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<ContainersAttribute> CONTAINERS = SerializationAttribute.withValue((String)Accessories.translationKey("containers"));

        public SerializationAttribute attribute() {
            return CONTAINERS;
        }

        public Object value() {
            return this;
        }
    }

    private record InvalidStacksAttribute(List<ItemStack> invalidStacks) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<InvalidStacksAttribute> INVALID_STACKS = SerializationAttribute.withValue((String)Accessories.translationKey("invalidStacks"));

        public SerializationAttribute attribute() {
            return INVALID_STACKS;
        }

        public Object value() {
            return this;
        }
    }
}

