/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.player.Player;

public class AccessoriesPlayerOptions
implements InstanceEndec {
    private PlayerEquipControl equipControl = PlayerEquipControl.MUST_NOT_CROUCH;
    private boolean showAdvancedOptions = false;
    private boolean showUnusedSlots = false;
    private boolean showCosmetics = false;
    private int columnAmount = 1;
    private int widgetType = 2;
    private boolean showGroupFilter = false;
    private boolean mainWidgetPosition = true;
    private boolean sideWidgetPosition = false;
    private boolean showCraftingGrid = false;
    private boolean isGroupFiltersOpen = true;
    private Set<String> filteredGroups = Set.of();
    public static final KeyedEndec<PlayerEquipControl> EQUIP_CONTROL_KEY = Endec.forEnum(PlayerEquipControl.class).keyed("equip_control", (Object)PlayerEquipControl.MUST_CROUCH);
    public static final KeyedEndec<Boolean> SHOW_UNUSED_SLOTS_KEY = Endec.BOOLEAN.keyed("show_unused_slots", (Object)false);
    public static final KeyedEndec<Boolean> SHOW_COSMETICS_KEY = Endec.BOOLEAN.keyed("show_cosmetics", (Object)false);
    public static final KeyedEndec<Integer> COLUMN_AMOUNT_KEY = Endec.INT.keyed("column_amount", (Object)1);
    public static final KeyedEndec<Integer> WIDGET_TYPE_KEY = Endec.INT.keyed("widget_type", (Object)2);
    public static final KeyedEndec<Boolean> MAIN_WIDGET_POSITION = Endec.BOOLEAN.keyed("main_widget_position", (Object)true);
    public static final KeyedEndec<Boolean> SIDE_WIDGET_POSITION = Endec.BOOLEAN.keyed("side_widget_position", (Object)false);
    public static final KeyedEndec<Boolean> SHOW_GROUP_FILTER = Endec.BOOLEAN.keyed("show_group_filter", (Object)false);
    public static final KeyedEndec<Boolean> IS_GROUP_FILTERS_OPEN_KEY = Endec.BOOLEAN.keyed("is_group_filter_open", (Object)false);
    public static final KeyedEndec<Set<String>> FILTERED_GROUPS_KEY = Endec.STRING.setOf().keyed("filtered_groups", HashSet::new);
    public static final KeyedEndec<Boolean> SHOW_CRAFTING_GRID = Endec.BOOLEAN.keyed("cosmetics_shown", (Object)false);

    public static AccessoriesPlayerOptions getOptions(Player player) {
        return AccessoriesInternals.getPlayerOptions(player);
    }

    public PlayerEquipControl equipControl() {
        return this.equipControl;
    }

    public AccessoriesPlayerOptions equipControl(PlayerEquipControl value) {
        this.equipControl = value;
        return this;
    }

    public boolean showUnusedSlots() {
        return this.showUnusedSlots;
    }

    public AccessoriesPlayerOptions showUnusedSlots(boolean value) {
        this.showUnusedSlots = value;
        return this;
    }

    public boolean showCosmetics() {
        return this.showCosmetics;
    }

    public AccessoriesPlayerOptions showCosmetics(boolean value) {
        this.showCosmetics = value;
        return this;
    }

    public int columnAmount() {
        return Math.max(this.columnAmount, 1);
    }

    public AccessoriesPlayerOptions columnAmount(int value) {
        this.columnAmount = value;
        return this;
    }

    public int widgetType() {
        return Math.max(this.widgetType, 1);
    }

    public AccessoriesPlayerOptions widgetType(int value) {
        this.widgetType = value;
        return this;
    }

    public boolean mainWidgetPosition() {
        return this.mainWidgetPosition;
    }

    public AccessoriesPlayerOptions mainWidgetPosition(boolean value) {
        this.mainWidgetPosition = value;
        return this;
    }

    public boolean showAdvancedOptions() {
        return this.showAdvancedOptions;
    }

    public AccessoriesPlayerOptions showAdvancedOptions(boolean value) {
        this.showAdvancedOptions = value;
        return this;
    }

    public boolean showGroupFilter() {
        return this.showGroupFilter;
    }

    public AccessoriesPlayerOptions showGroupFilter(boolean value) {
        this.showGroupFilter = value;
        return this;
    }

    public boolean isGroupFiltersOpen() {
        return this.isGroupFiltersOpen;
    }

    public AccessoriesPlayerOptions isGroupFiltersOpen(boolean value) {
        this.isGroupFiltersOpen = value;
        return this;
    }

    public Set<String> filteredGroups() {
        return this.filteredGroups;
    }

    public AccessoriesPlayerOptions filteredGroups(Set<String> value) {
        this.filteredGroups = value;
        return this;
    }

    public boolean sideWidgetPosition() {
        return this.sideWidgetPosition;
    }

    public AccessoriesPlayerOptions sideWidgetPosition(boolean value) {
        this.sideWidgetPosition = value;
        return this;
    }

    public boolean showCraftingGrid() {
        return this.showCraftingGrid;
    }

    public AccessoriesPlayerOptions showCraftingGrid(boolean value) {
        this.showCraftingGrid = value;
        return this;
    }

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        carrier.put(ctx, EQUIP_CONTROL_KEY, (Object)this.equipControl);
        carrier.put(ctx, COLUMN_AMOUNT_KEY, (Object)this.columnAmount);
        carrier.put(ctx, WIDGET_TYPE_KEY, (Object)this.widgetType);
        carrier.put(ctx, MAIN_WIDGET_POSITION, (Object)this.mainWidgetPosition);
        carrier.put(ctx, SIDE_WIDGET_POSITION, (Object)this.sideWidgetPosition);
        carrier.put(ctx, SHOW_COSMETICS_KEY, (Object)this.showCosmetics);
        carrier.put(ctx, SHOW_UNUSED_SLOTS_KEY, (Object)this.showUnusedSlots);
        carrier.put(ctx, SHOW_GROUP_FILTER, (Object)this.showGroupFilter);
        carrier.put(ctx, IS_GROUP_FILTERS_OPEN_KEY, (Object)this.isGroupFiltersOpen);
        carrier.put(ctx, FILTERED_GROUPS_KEY, this.filteredGroups);
        carrier.put(ctx, SHOW_CRAFTING_GRID, (Object)this.showCraftingGrid);
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        this.equipControl = (PlayerEquipControl)((Object)carrier.get(ctx, EQUIP_CONTROL_KEY));
        this.columnAmount = (Integer)carrier.get(ctx, COLUMN_AMOUNT_KEY);
        this.widgetType = (Integer)carrier.get(ctx, WIDGET_TYPE_KEY);
        this.mainWidgetPosition = (Boolean)carrier.get(ctx, MAIN_WIDGET_POSITION);
        this.sideWidgetPosition = (Boolean)carrier.get(ctx, SIDE_WIDGET_POSITION);
        this.showCosmetics = (Boolean)carrier.get(ctx, SHOW_COSMETICS_KEY);
        this.showUnusedSlots = (Boolean)carrier.get(ctx, SHOW_UNUSED_SLOTS_KEY);
        this.showGroupFilter = (Boolean)carrier.get(ctx, SHOW_GROUP_FILTER);
        this.isGroupFiltersOpen = (Boolean)carrier.get(ctx, IS_GROUP_FILTERS_OPEN_KEY);
        this.filteredGroups = (Set)carrier.get(ctx, FILTERED_GROUPS_KEY);
        this.showCraftingGrid = (Boolean)carrier.get(ctx, SHOW_CRAFTING_GRID);
    }
}

