/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.owo.util.EventSource;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ExpandedSimpleContainer
extends SimpleContainer
implements Iterable<Pair<Integer, ItemStack>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesContainerImpl container;
    private final String name;
    private final NonNullList<ItemStack> previousItems;
    private final Int2BooleanMap setFlags = new Int2BooleanArrayMap();
    private boolean newlyConstructed;
    private final Int2ObjectMap<EventSource.Subscription> currentSubscriptions = new Int2ObjectOpenHashMap();

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name) {
        this(container, size, name, true);
    }

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name, boolean toggleNewlyConstructed) {
        super(size);
        this.container = container;
        this.addListener(container);
        if (toggleNewlyConstructed) {
            this.newlyConstructed = true;
        }
        this.name = name;
        this.previousItems = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public String name() {
        return this.name;
    }

    public boolean wasNewlyConstructed() {
        boolean bl = this.newlyConstructed;
        this.newlyConstructed = false;
        return bl;
    }

    public boolean isSlotFlagged(int slot) {
        boolean bl = this.setFlags.getOrDefault(slot, false);
        if (bl) {
            this.setFlags.put(slot, false);
        }
        return bl;
    }

    public void setPreviousItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.previousItems.size()) {
            this.previousItems.set(slot, (Object)stack);
            if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
        }
    }

    public ItemStack getPreviousItem(int slot) {
        return slot >= 0 && slot < this.previousItems.size() ? (ItemStack)this.previousItems.get(slot) : ItemStack.EMPTY;
    }

    public int getMaxStackSize(ItemStack itemStack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(itemStack);
        return Math.min(super.getMaxStackSize(itemStack), accessory.maxStackSize(itemStack));
    }

    public ItemStack getItem(int slot) {
        if (!this.validIndex(slot)) {
            return ItemStack.EMPTY;
        }
        return super.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        if (!this.validIndex(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = super.removeItem(slot, amount);
        if (!stack.isEmpty()) {
            EventSource.Subscription subscription;
            this.setFlags.put(slot, true);
            ItemStack prevStack = this.getItem(slot);
            if (prevStack.isEmpty() && (subscription = (EventSource.Subscription)this.currentSubscriptions.remove(slot)) != null) {
                subscription.cancel();
            }
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (!this.validIndex(slot)) {
            return ItemStack.EMPTY;
        }
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
        return super.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
        super.setItem(slot, stack);
        if (!stack.isEmpty()) {
            this.currentSubscriptions.put(slot, (Object)ItemStackMutation.getEvent(stack).source().subscribe((stack1, types) -> {
                AccessoriesHolderLookupCache cache;
                if (types.contains(AccessoriesDataComponents.ATTRIBUTES) || types.contains(AccessoriesDataComponents.NESTED_ACCESSORIES)) {
                    this.setChanged();
                }
                if (!this.container.capability.entity().level().isClientSide() && (cache = AccessoriesHolderImpl.getHolder(this.container.capability).getLookupCache()) != null) {
                    cache.invalidateLookupData(this.container.getSlotName(), stack1, types);
                }
            }));
        }
        this.setFlags.put(slot, true);
    }

    public boolean validIndex(int slot) {
        String nameInfo;
        boolean isValid = slot >= 0 && slot < this.getContainerSize();
        String string = nameInfo = this.name != null ? "Container: " + this.name + ", " : "";
        if (!isValid && FabricLoader.getInstance().isDevelopmentEnvironment()) {
            try {
                throw new IllegalStateException("Access to a given Inventory was found to be out of the range valid for the container! [Name: " + nameInfo + " Index: " + slot + "]");
            }
            catch (Exception e) {
                LOGGER.debug("Full Exception: ", (Throwable)e);
            }
        }
        return isValid;
    }

    public void fromTag(ListTag containerNbt, HolderLookup.Provider provider) {
        this.container.containerListenerLock = true;
        AccessoriesCapability capability = this.container.capability;
        ArrayList<ItemStack> prevStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack currentStack = this.getItem(i);
            prevStacks.add(currentStack);
            this.setItem(i, ItemStack.EMPTY);
        }
        ArrayList<ItemStack> invalidStacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> decodedStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < containerNbt.size(); ++i) {
            CompoundTag compoundTag = containerNbt.getCompound(i);
            int j = compoundTag.getInt("Slot");
            ItemStack stack = this.parseOptional(provider, (Tag)compoundTag);
            decodedStacks.add(stack);
            if (j >= 0 && j < this.getContainerSize()) {
                this.setItem(j, stack);
                continue;
            }
            invalidStacks.add(stack);
        }
        this.container.containerListenerLock = false;
        if (!capability.entity().level().isClientSide()) {
            if (!prevStacks.equals(decodedStacks)) {
                this.setChanged();
            }
            AccessoriesHolderImpl.getHolder((AccessoriesCapability)capability).invalidStacks.addAll(invalidStacks);
        }
    }

    public ItemStack parseOptional(HolderLookup.Provider lookupProvider, Tag tag) {
        return ItemStack.CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(string -> {
            LOGGER.error("[ExpandedSimpleContainer] An error has occured while decoding stack!");
            LOGGER.error(" - Entity Effected: '{}'", (Object)this.container.capability.entity().toString());
            LOGGER.error(" - Container Name: '{}'", (Object)this.container.getSlotName());
            LOGGER.error(" - Tried to load invalid item: '{}'", string);
            LOGGER.error(" - Stack Data: '{}'", (Object)tag.toString());
        }).orElse(ItemStack.EMPTY);
    }

    public ListTag createTag(HolderLookup.Provider provider) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("Slot", i);
            listTag.add((Object)itemStack.save(provider, (Tag)compoundTag));
        }
        return listTag;
    }

    @Override
    @NotNull
    public Iterator<Pair<Integer, ItemStack>> iterator() {
        return new Iterator<Pair<Integer, ItemStack>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ExpandedSimpleContainer.this.getContainerSize();
            }

            @Override
            public Pair<Integer, ItemStack> next() {
                Pair pair = new Pair((Object)this.index, (Object)ExpandedSimpleContainer.this.getItem(this.index));
                ++this.index;
                return pair;
            }
        };
    }

    public void setFromPrev(ExpandedSimpleContainer prevContainer) {
        prevContainer.forEach(pair -> this.setPreviousItem((Integer)pair.getFirst(), (ItemStack)pair.getSecond()));
    }

    public void copyPrev(ExpandedSimpleContainer prevContainer) {
        for (int i = 0; i < prevContainer.getContainerSize(); ++i) {
            ItemStack prevItem;
            if (i >= this.getContainerSize() || (prevItem = prevContainer.getPreviousItem(i)).isEmpty()) continue;
            this.setPreviousItem(i, prevItem);
        }
    }
}

