/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.caching;

import com.google.common.cache.Cache;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.caching.AccessoriesContainerLookupCache;
import io.wispforest.accessories.impl.caching.EquipmentLookupCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesHolderLookupCache
extends EquipmentLookupCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesHolderImpl holder;
    private final Map<String, AccessoriesContainerLookupCache> containerLookupCacheMap = new HashMap<String, AccessoriesContainerLookupCache>();

    public AccessoriesHolderLookupCache(AccessoriesHolderImpl holder) {
        this.holder = holder;
    }

    @Override
    public boolean isEquipped(ItemStackBasedPredicate predicate) {
        Boolean value = (Boolean)this.isEquipped.getIfPresent((Object)predicate);
        if (value == null) {
            AccessoriesContainerLookupCache lookupCache;
            Iterator<AccessoriesContainerLookupCache> iterator = this.containerLookupCacheMap.values().iterator();
            while (iterator.hasNext() && !(value = Boolean.valueOf((lookupCache = iterator.next()).isEquipped(predicate))).booleanValue()) {
            }
            if (value == null) {
                value = false;
            }
            this.isEquipped.put((Object)predicate, (Object)value);
        }
        return value;
    }

    @Override
    @Nullable
    public SlotEntryReference firstEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        Cache cache = check == EquipmentChecking.ACCESSORIES_ONLY ? this.firstEquipped_ACCESSORIES_ONLY : this.firstEquipped_COSMETICALLY_OVERRIDABLE;
        Optional<Object> value = (Optional<Object>)cache.getIfPresent((Object)predicate);
        if (value == null) {
            for (AccessoriesContainerLookupCache lookupCache : this.containerLookupCacheMap.values()) {
                SlotEntryReference cacheResult = lookupCache.firstEquipped(predicate, check);
                if (cacheResult == null) continue;
                value = Optional.of(cacheResult);
                break;
            }
            if (value == null) {
                value = Optional.empty();
            }
            cache.put((Object)predicate, value);
        }
        return value.orElse(null);
    }

    @Override
    public List<SlotEntryReference> getEquipped(ItemStackBasedPredicate predicate) {
        ArrayList<SlotEntryReference> value = (ArrayList<SlotEntryReference>)this.equipped.getIfPresent((Object)predicate);
        if (value == null) {
            value = new ArrayList<SlotEntryReference>();
            for (AccessoriesContainerLookupCache lookupCache : this.containerLookupCacheMap.values()) {
                List<SlotEntryReference> cacheResult = lookupCache.getEquipped(predicate);
                if (cacheResult == null) continue;
                value.addAll(cacheResult);
            }
            this.equipped.put((Object)predicate, value);
        }
        return value;
    }

    @Override
    public List<SlotEntryReference> getAllEquipped() {
        if (this.getAllEquipped != null) {
            return this.getAllEquipped;
        }
        ArrayList<SlotEntryReference> currentlyAllEquipped = new ArrayList<SlotEntryReference>();
        for (AccessoriesContainerLookupCache value : this.containerLookupCacheMap.values()) {
            currentlyAllEquipped.addAll(value.getAllEquipped());
        }
        this.getAllEquipped = currentlyAllEquipped;
        return currentlyAllEquipped;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        for (String string2 : Set.copyOf(this.containerLookupCacheMap.keySet())) {
            AccessoriesContainer container = this.holder.getSlotContainers().get(string2);
            if (container != null) {
                this.containerLookupCacheMap.get(string2).clearCache();
                continue;
            }
            this.containerLookupCacheMap.remove(string2);
        }
        for (Map.Entry entry : this.holder.getSlotContainers().entrySet()) {
            this.containerLookupCacheMap.computeIfAbsent((String)entry.getKey(), string -> new AccessoriesContainerLookupCache((AccessoriesContainer)entry.getValue())).clearCache();
        }
    }

    public void clearContainerCache(String key) {
        AccessoriesContainerLookupCache containerCache = this.containerLookupCacheMap.get(key);
        if (containerCache == null) {
            throw new IllegalStateException("Unable to clear the cache! [Key: " + key + "]");
        }
        if (containerCache.isEmpty()) {
            return;
        }
        containerCache.clearCache();
        super.clearCache();
    }

    public void invalidateLookupData(String key, ItemStack stack, List<DataComponentType<?>> types) {
        this.clearContainerCache(key);
    }
}

