/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.pond.EnchantedItemInUseExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentMixin {
    @Inject(method={"runLocationChangedEffects(Lnet/minecraft/server/level/ServerLevel;ILnet/minecraft/world/item/enchantment/EnchantedItemInUse;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void failSafeForInvalidRecordObjects1(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, LivingEntity entity, CallbackInfo ci) {
        SlotReference ref;
        if (item.inSlot() == AccessoriesInternals.INTERNAL_SLOT && (ref = ((EnchantedItemInUseExtension)item).getSlotReference()) == null) {
            ci.cancel();
        }
    }

    @Inject(method={"stopLocationBasedEffects(ILnet/minecraft/world/item/enchantment/EnchantedItemInUse;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void failSafeForInvalidRecordObjects2(int enchantmentLevel, EnchantedItemInUse item, LivingEntity entity, CallbackInfo ci) {
        SlotReference ref;
        if (item.inSlot() == AccessoriesInternals.INTERNAL_SLOT && (ref = ((EnchantedItemInUseExtension)item).getSlotReference()) == null) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"runLocationChangedEffects(Lnet/minecraft/server/level/ServerLevel;ILnet/minecraft/world/item/enchantment/EnchantedItemInUse;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private boolean checkIfEnchantmentValid(Enchantment instance, EquipmentSlot slot, Operation<Boolean> original, @Local(argsOnly=true) ServerLevel level) {
        return slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT) ? (Boolean)original.call(new Object[]{instance, slot}) : EnchantmentMixin.enchantmentValidForRedirect(level.registryAccess(), instance);
    }

    @WrapOperation(method={"runLocationChangedEffects(Lnet/minecraft/server/level/ServerLevel;ILnet/minecraft/world/item/enchantment/EnchantedItemInUse;Lnet/minecraft/world/entity/LivingEntity;)V", "stopLocationBasedEffects(ILnet/minecraft/world/item/enchantment/EnchantedItemInUse;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;activeLocationDependentEnchantments(Lnet/minecraft/world/entity/EquipmentSlot;)Ljava/util/Map;")})
    private Map<Enchantment, Set<EnchantmentLocationBasedEffect>> adjustMapLookupForRecord(LivingEntity instance, EquipmentSlot slot, Operation<Map<Enchantment, Set<EnchantmentLocationBasedEffect>>> original, @Local(argsOnly=true) EnchantedItemInUse item) {
        if (slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT)) {
            SlotReference ref = ((EnchantedItemInUseExtension)item).getSlotReference();
            return ref != null ? ((AccessoriesLivingEntityExtension)instance).activeLocationDependentEnchantmentsFromSlotReference(ref) : new HashMap();
        }
        return (Map)original.call(new Object[]{instance, slot});
    }

    @Unique
    private static boolean enchantmentValidForRedirect(RegistryAccess access, Enchantment enchantment) {
        Registry enchantments = access.lookupOrThrow(Registries.ENCHANTMENT);
        return !((Holder.Reference)enchantments.get((ResourceKey)enchantments.getResourceKey((Object)enchantment).orElseThrow()).orElseThrow()).is(AccessoriesTags.INVALID_FOR_REDIRECTION);
    }
}

