/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.wispforest.accessories.pond.stack.PatchedDataComponentMapExtension;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.owo.util.EventStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatchedDataComponentMap.class})
public abstract class PatchedDataComponentMapMixin
implements PatchedDataComponentMapExtension {
    @Unique
    private boolean changeCheckStack = false;
    private ItemStack itemStack;
    private EventStream<ItemStackMutation> mutationEvent = new EventStream(invokers -> (stack, types) -> invokers.forEach(itemStackMutation -> itemStackMutation.onMutation(stack, types)));
    @Unique
    private boolean inApplyPatchLock = false;

    @Override
    public EventStream<ItemStackMutation> accessories$getMutationEvent(ItemStack stack) {
        this.itemStack = stack;
        return this.mutationEvent;
    }

    @Override
    public boolean accessories$hasChanged() {
        boolean bl = this.changeCheckStack;
        this.changeCheckStack = false;
        return bl;
    }

    @Inject(method={"set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_set(DataComponentType<? super T> component, @Nullable T value, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, List.of(component));
    }

    @Inject(method={"remove(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"}, at={@At(value="HEAD")})
    private <T> void accessories$updateChangeValue_remove(DataComponentType<? super T> component, CallbackInfoReturnable<T> cir) {
        this.changeCheckStack = true;
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, List.of(component));
    }

    @WrapMethod(method={"applyPatch(Lnet/minecraft/core/component/DataComponentPatch;)V", "method_57936(Lnet/minecraft/class_9326;)V", "applyChanges(Lnet/minecraft/component/ComponentChanges;)V"}, expect=1, require=1, allow=1)
    private void accessories$updateChangeValue(DataComponentPatch patch, Operation<Void> original) {
        this.changeCheckStack = true;
        this.inApplyPatchLock = true;
        original.call(new Object[]{patch});
        this.inApplyPatchLock = false;
        List<DataComponentType<?>> changedDataTypes = patch.entrySet().stream().map(Map.Entry::getKey).toList();
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, changedDataTypes);
    }

    @Inject(method={"applyPatch(Lnet/minecraft/core/component/DataComponentType;Ljava/util/Optional;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_applyPatch(DataComponentType<?> component, Optional<?> value, CallbackInfo ci) {
        this.changeCheckStack = true;
        if (!this.inApplyPatchLock) {
            ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, List.of(component));
        }
    }

    @Inject(method={"restorePatch(Lnet/minecraft/core/component/DataComponentPatch;)V"}, at={@At(value="HEAD")})
    private void accessories$updateChangeValue_restorePatch(DataComponentPatch patch, CallbackInfo ci) {
        this.changeCheckStack = true;
        List<DataComponentType<?>> changedDataTypes = patch.entrySet().stream().map(Map.Entry::getKey).toList();
        ((ItemStackMutation)this.mutationEvent.sink()).onMutation(this.itemStack, changedDataTypes);
    }
}

