/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.equip.EquipmentChecking;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.mixin.client.EquipmentLayerRendererAccessor;
import io.wispforest.accessories.pond.LivingEntityRenderStateExtension;
import io.wispforest.accessories.pond.WingsLayerExtension;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={WingsLayer.class})
public abstract class WingsLayerMixin<S extends HumanoidRenderState, M extends EntityModel<S>>
implements WingsLayerExtension<S> {
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private boolean hasPrintedError = false;
    @Shadow
    @Final
    private EquipmentLayerRenderer equipmentRenderer;

    @Shadow
    public abstract void render(PoseStack var1, MultiBufferSource var2, int var3, S var4, float var5, float var6);

    @Override
    public void renderStack(ItemStack stack, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, S humanoidRenderState) {
        ItemStack prevItem = ((HumanoidRenderState)humanoidRenderState).chestEquipment;
        ((HumanoidRenderState)humanoidRenderState).chestEquipment = stack;
        this.render(poseStack, multiBufferSource, i, humanoidRenderState, ((HumanoidRenderState)humanoidRenderState).yRot, ((HumanoidRenderState)humanoidRenderState).xRot);
        ((HumanoidRenderState)humanoidRenderState).chestEquipment = prevItem;
    }

    @WrapOperation(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/HumanoidRenderState;FF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")})
    private Object accessories$adjustGliderItemstack(ItemStack instance, DataComponentType dataComponentType, Operation<Object> original, @Local(argsOnly=true) S humanoidRenderState, @Local(ordinal=0) LocalRef<ItemStack> stack) {
        if (humanoidRenderState instanceof LivingEntityRenderStateExtension) {
            LivingEntityRenderStateExtension extension = (LivingEntityRenderStateExtension)humanoidRenderState;
            Optional<LivingEntity> entity = extension.getEntity();
            if (entity.isPresent()) {
                SlotEntryReference gliderItem;
                AccessoriesCapability capability = entity.get().accessoriesCapability();
                if (capability != null && (gliderItem = capability.getFirstEquipped(stack1 -> {
                    Equippable equippable = (Equippable)stack1.get(DataComponents.EQUIPPABLE);
                    if (equippable != null && equippable.assetId().isPresent()) {
                        List list = ((EquipmentLayerRendererAccessor)this.equipmentRenderer).accessories$equipmentAssetManager().get((ResourceKey)equippable.assetId().get()).getLayers(EquipmentClientInfo.LayerType.WINGS);
                        return !list.isEmpty();
                    }
                    return false;
                }, EquipmentChecking.COSMETICALLY_OVERRIDABLE)) != null) {
                    stack.set((Object)gliderItem.stack());
                    instance = gliderItem.stack();
                }
            } else if (!this.hasPrintedError) {
                LOGGER.error("Unable to get the required Living Entity instance from the given LivingEntityRenderState meaning Accessories may not render!");
                this.hasPrintedError = true;
            }
        }
        return original.call(new Object[]{instance, dataComponentType});
    }
}

