/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.neoforge.client;

import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.AccessoriesRenderLayer;
import io.wispforest.accessories.impl.AccessoriesEventHandler;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Mod(value="accessories", dist={Dist.CLIENT})
public class AccessoriesClientForge {
    public AccessoriesClientForge(IEventBus eventBus) {
        eventBus.addListener(this::registerMenuType);
        eventBus.addListener(this::onInitializeClient);
        eventBus.addListener(this::initKeybindings);
        eventBus.addListener(this::addRenderLayer);
        NeoForge.EVENT_BUS.addListener(this::onJoin);
        AccessoriesClient.initConfigStuff();
    }

    public void registerMenuType(RegisterMenuScreensEvent event) {
        AccessoriesMenuTypes.registerClientMenuConstructors((arg_0, arg_1) -> ((RegisterMenuScreensEvent)event).register(arg_0, arg_1));
    }

    public void onJoin(ClientPlayerNetworkEvent.LoggingIn loggingInEvent) {
        AccessoriesClient.initalConfigDataSync();
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(AccessoriesClientForge::clientTick);
        NeoForge.EVENT_BUS.addListener(AccessoriesClientForge::itemTooltipCallback);
        AccessoriesClient.init();
        AccessoriesNetworking.initClient();
    }

    public void initKeybindings(RegisterKeyMappingsEvent event) {
        AccessoriesClient.OPEN_SCREEN = new KeyMapping("accessories.key.open_accessories_screen", 72, "accessories.key.category.accessories");
        event.register(AccessoriesClient.OPEN_SCREEN);
    }

    public static void clientTick(ClientTickEvent.Pre event) {
        if (AccessoriesClient.OPEN_SCREEN.consumeClick()) {
            AccessoriesClient.openScreenFromKey();
        }
    }

    public static void itemTooltipCallback(ItemTooltipEvent event) {
        Player player = event.getEntity();
        List stackTooltip = event.getToolTip();
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        AccessoriesEventHandler.getTooltipData((LivingEntity)player, event.getItemStack(), tooltipData, event.getContext(), event.getFlags());
        if (!tooltipData.isEmpty()) {
            stackTooltip.addAll(1, tooltipData);
        }
    }

    public void addRenderLayer(EntityRenderersEvent.AddLayers event) {
        for (EntityType entityType : event.getEntityTypes()) {
            try {
                LivingEntityRenderer livingEntityRenderer;
                EntityRenderer renderer = event.getRenderer(entityType);
                if (!(renderer instanceof LivingEntityRenderer) || !((livingEntityRenderer = (LivingEntityRenderer)renderer).getModel() instanceof HumanoidModel)) continue;
                livingEntityRenderer.addLayer(new AccessoriesRenderLayer(livingEntityRenderer));
            }
            catch (ClassCastException classCastException) {}
        }
        event.getSkins().forEach(model -> {
            LivingEntityRenderer livingEntityRenderer;
            EntityRenderer renderer = event.getSkin(model);
            if (renderer instanceof LivingEntityRenderer && (livingEntityRenderer = (LivingEntityRenderer)renderer).getModel() instanceof HumanoidModel) {
                livingEntityRenderer.addLayer(new AccessoriesRenderLayer(livingEntityRenderer));
            }
        });
    }
}

