/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public record SyncContainerData(int entityId, Map<String, NbtMapCarrier> updatedContainers, Map<String, ItemStack> dirtyStacks, Map<String, ItemStack> dirtyCosmeticStacks) {
    public static StructEndec<SyncContainerData> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncContainerData::entityId), (StructField)NbtMapCarrier.ENDEC.mapOf().fieldOf("updatedContainers", SyncContainerData::updatedContainers), (StructField)CodecUtils.toEndec((Codec)ItemStack.OPTIONAL_CODEC).mapOf().fieldOf("dirtyStacks", SyncContainerData::dirtyStacks), (StructField)CodecUtils.toEndec((Codec)ItemStack.OPTIONAL_CODEC).mapOf().fieldOf("dirtyCosmeticStacks", SyncContainerData::dirtyCosmeticStacks), SyncContainerData::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static SyncContainerData of(LivingEntity livingEntity, Collection<AccessoriesContainer> updatedContainers, Map<String, ItemStack> dirtyStacks, Map<String, ItemStack> dirtyCosmeticStacks) {
        HashMap<String, NbtMapCarrier> updatedContainerTags = new HashMap<String, NbtMapCarrier>();
        for (AccessoriesContainer updatedContainer : updatedContainers) {
            NbtMapCarrier syncCarrier = NbtMapCarrier.of();
            ((AccessoriesContainerImpl)updatedContainer).write(syncCarrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)livingEntity.registryAccess())}), true);
            updatedContainerTags.put(updatedContainer.getSlotName(), syncCarrier);
        }
        return new SyncContainerData(livingEntity.getId(), updatedContainerTags, dirtyStacks, dirtyCosmeticStacks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(SyncContainerData packet, Player player) {
        AbstractContainerMenu abstractContainerMenu;
        AccessoriesHolderLookupCache accessoriesHolderLookupCache;
        Level level = player.level();
        Entity entity = level.getEntity(packet.entityId());
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        boolean aContainerHasResized = false;
        HashSet<String> changedContainers = new HashSet<String>();
        HashSet<String> invalidSyncedContainers = new HashSet<String>();
        for (Map.Entry<String, NbtMapCarrier> entry : packet.updatedContainers().entrySet()) {
            if (!containers.containsKey(entry.getKey())) {
                invalidSyncedContainers.add(entry.getKey());
                continue;
            }
            AccessoriesContainer accessoriesContainer = containers.get(entry.getKey());
            changedContainers.add(accessoriesContainer.getSlotName());
            ((AccessoriesContainerImpl)accessoriesContainer).read((MapCarrier)entry.getValue(), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)player.level().registryAccess())}), true);
            if (!accessoriesContainer.getAccessories().wasNewlyConstructed()) continue;
            aContainerHasResized = true;
        }
        if (!invalidSyncedContainers.isEmpty()) {
            LOGGER.warn("Unable to sync container data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyStackContainers = new HashSet<String>();
        for (Map.Entry entry : packet.dirtyStacks().entrySet()) {
            String[] stringArray = ((String)entry.getKey()).split("/");
            String slot = stringArray[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyStackContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            changedContainers.add(container.getSlotName());
            try {
                container.getAccessories().setItem(Integer.parseInt(stringArray[1]), (ItemStack)entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyStackContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        HashSet<String> invalidDirtyCosmeticContainers = new HashSet<String>();
        for (Map.Entry<String, ItemStack> entry : packet.dirtyCosmeticStacks().entrySet()) {
            String[] parts = entry.getKey().split("/");
            String slot = parts[0];
            if (!containers.containsKey(slot)) {
                invalidDirtyCosmeticContainers.add(slot);
                continue;
            }
            AccessoriesContainer container = containers.get(slot);
            changedContainers.add(container.getSlotName());
            try {
                container.getCosmeticAccessories().setItem(Integer.parseInt(parts[1]), entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!invalidDirtyCosmeticContainers.isEmpty()) {
            LOGGER.warn("Unable to sync dirty stack data for the following containers: {}", invalidSyncedContainers);
        }
        if ((accessoriesHolderLookupCache = AccessoriesHolderImpl.getHolder(capability).getLookupCache()) != null) {
            changedContainers.forEach(accessoriesHolderLookupCache::clearContainerCache);
        }
        if ((abstractContainerMenu = player.containerMenu) instanceof AccessoriesMenuBase) {
            AccessoriesMenuBase accessoriesMenuBase = (AccessoriesMenuBase)abstractContainerMenu;
            if (aContainerHasResized) {
                accessoriesMenuBase.reopenMenu();
            }
        }
    }
}

