/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.holder;

import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.impl.AccessoriesPlayerOptions;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.PlayerOption;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record SyncOptionChange(PlayerOption<?> property, Object data) {
    public static final StructEndec<SyncOptionChange> ENDEC = new StructEndec<SyncOptionChange>(){

        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, SyncOptionChange value) {
            struct.field("property", ctx, PlayerOption.ENDEC, value.property());
            struct.field("value", ctx, value.property().endec(), value.data());
        }

        public SyncOptionChange decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            PlayerOption prop = (PlayerOption)struct.field("property", ctx, PlayerOption.ENDEC);
            return new SyncOptionChange(prop, struct.field("value", ctx, prop.endec()));
        }
    };

    public static <T> SyncOptionChange of(PlayerOption<T> property, T data) {
        return new SyncOptionChange(property, data);
    }

    public static <T> SyncOptionChange of(PlayerOption<T> property, Player player, Function<T, T> operation) {
        return new SyncOptionChange(property, operation.apply(property.getter().apply(AccessoriesPlayerOptions.getOptions(player))));
    }

    public static void handlePacket(SyncOptionChange packet, Player player) {
        packet.property().setData(player, packet.data());
        if (player.level().isClientSide()) {
            SyncOptionChange.handleClient(packet, player);
        } else {
            AccessoriesNetworking.sendToPlayer((ServerPlayer)player, SyncOptionChange.of(packet.property(), packet.property().getter().apply(AccessoriesPlayerOptions.getOptions(player))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(SyncOptionChange packet, Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AccessoriesScreenBase) {
            AccessoriesScreenBase accessoriesScreen = (AccessoriesScreenBase)screen;
            accessoriesScreen.onHolderChange(packet.property().name());
        }
    }
}

