/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.access.BeeGoalAccess;
import house.greenhouse.bovinesandbuttercups.access.MobEffectInstanceLockdownDataAccess;
import house.greenhouse.bovinesandbuttercups.access.MooshroomInitializedTypeAccess;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.api.attachment.LockdownAttachment;
import house.greenhouse.bovinesandbuttercups.api.attachment.MooshroomExtrasAttachment;
import house.greenhouse.bovinesandbuttercups.api.variant.CowModelLayer;
import house.greenhouse.bovinesandbuttercups.api.variant.modifier.TextureModifierFactory;
import house.greenhouse.bovinesandbuttercups.content.advancement.criterion.LockEffectTrigger;
import house.greenhouse.bovinesandbuttercups.content.advancement.criterion.PreventEffectTrigger;
import house.greenhouse.bovinesandbuttercups.content.attachment.BovinesAttachments;
import house.greenhouse.bovinesandbuttercups.content.block.entity.MoobloomEatDispenseBehavior;
import house.greenhouse.bovinesandbuttercups.content.command.BovinesCommands;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MooshroomConfiguration;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.content.entity.BovinesEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.entity.Moobloom;
import house.greenhouse.bovinesandbuttercups.content.entity.goal.MoveToMoobloomGoal;
import house.greenhouse.bovinesandbuttercups.content.entity.goal.PollinateMoobloomGoal;
import house.greenhouse.bovinesandbuttercups.content.item.BovinesItems;
import house.greenhouse.bovinesandbuttercups.mixin.AnimalAccessor;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncConditionedTextureModifier;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncCowVariantClientboundPacket;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncLockdownEffectsClientboundPacket;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncMoobloomSnowLayerClientboundPacket;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncMooshroomExtrasClientboundPacket;
import house.greenhouse.bovinesandbuttercups.platform.BovinesPlatformHelperNeoForge;
import house.greenhouse.bovinesandbuttercups.util.CreativeTabHelper;
import house.greenhouse.bovinesandbuttercups.util.LockdownData;
import house.greenhouse.bovinesandbuttercups.util.MooshroomChildTypeUtil;
import house.greenhouse.bovinesandbuttercups.util.MooshroomSpawnUtil;
import house.greenhouse.bovinesandbuttercups.util.SnowLayerUtil;
import house.greenhouse.bovinesandbuttercups.util.WeatherUtil;
import house.greenhouse.bovinesandbuttercups.util.dfu.BovinesDataFixer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="bovinesandbuttercups")
public class BovinesAndButtercupsNeoForge {
    public BovinesAndButtercupsNeoForge(IEventBus eventBus) {
        BovinesAndButtercups.init(new BovinesPlatformHelperNeoForge());
    }

    private static void insertAfter(Set<ItemStack> stacks, Item start, List<ItemStack> itemsToAdd, AddAfterOperation operation) {
        ItemStack startItem = null;
        for (ItemStack entry : stacks) {
            if (!entry.is(start)) continue;
            startItem = entry;
            break;
        }
        if (startItem != null) {
            for (ItemStack stack : itemsToAdd) {
                operation.insertAfter(startItem, stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                startItem = stack;
            }
        }
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addPackFinders(BovinesAndButtercups.asResource("resourcepacks/mojang"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.bovinesandbuttercups.mojang.name"), BovinesAndButtercupsNeoForge.createSource(false), false, Pack.Position.TOP);
            event.addPackFinders(BovinesAndButtercups.asResource("resourcepacks/no_buds"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.bovinesandbuttercups.noBuds.name"), BovinesAndButtercupsNeoForge.createSource(false), false, Pack.Position.TOP);
            event.addPackFinders(BovinesAndButtercups.asResource("resourcepacks/no_grass"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.bovinesandbuttercups.noGrass.name"), BovinesAndButtercupsNeoForge.createSource(false), false, Pack.Position.TOP);
        }
    }

    private static PackSource createSource(final boolean enabledByDefault) {
        return new PackSource(){

            public Component decorate(Component component) {
                return Component.translatable((String)"pack.bovinesandbuttercups.builtin", (Object[])new Object[]{component});
            }

            public boolean shouldAddAutomatically() {
                return enabledByDefault;
            }
        };
    }

    @FunctionalInterface
    private static interface AddAfterOperation {
        public void insertAfter(ItemStack var1, ItemStack var2, CreativeModeTab.TabVisibility var3);
    }

    @EventBusSubscriber(modid="bovinesandbuttercups", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            MoobloomEatDispenseBehavior.registerBehavior(MoobloomEatDispenseBehavior.INSTANCE);
            BovinesDataFixer.register();
        }

        @SubscribeEvent
        public static void createEntityAttributes(EntityAttributeCreationEvent event) {
            event.put(BovinesEntityTypes.MOOBLOOM, Moobloom.createAttributes().build());
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(BovinesEntityTypes.MOOBLOOM, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Moobloom::canMoobloomSpawn, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void modifySpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(EntityType.MOOSHROOM, (entityType, levelAccessor, mobSpawnType, blockPos, randomSource) -> MooshroomSpawnUtil.getTotalSpawnWeight((LevelAccessor)levelAccessor, blockPos) > 0, RegisterSpawnPlacementsEvent.Operation.AND);
            event.register(EntityType.MOOSHROOM, (entityType, levelAccessor, mobSpawnType, blockPos, randomSource) -> !levelAccessor.getBiome(blockPos).is(Biomes.MUSHROOM_FIELDS) && levelAccessor.getBlockState(blockPos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && AnimalAccessor.bovinesandbuttercups$invokeIsBrightEnoughToSpawn((BlockAndTintGetter)levelAccessor, blockPos) && MooshroomSpawnUtil.getTotalSpawnWeight((LevelAccessor)levelAccessor, blockPos) > 0, RegisterSpawnPlacementsEvent.Operation.OR);
        }

        @SubscribeEvent
        public static void registerPackets(RegisterPayloadHandlersEvent event) {
            event.registrar("2.0.0").playToClient(SyncConditionedTextureModifier.TYPE, SyncConditionedTextureModifier.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncCowVariantClientboundPacket.TYPE, SyncCowVariantClientboundPacket.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncLockdownEffectsClientboundPacket.TYPE, SyncLockdownEffectsClientboundPacket.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncMoobloomSnowLayerClientboundPacket.TYPE, SyncMoobloomSnowLayerClientboundPacket.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncMooshroomExtrasClientboundPacket.TYPE, SyncMooshroomExtrasClientboundPacket.STREAM_CODEC, (payload, context) -> payload.handle());
        }

        @SubscribeEvent
        public static void buildCreativeModeTabs(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
                BovinesAndButtercupsNeoForge.insertAfter((Set<ItemStack>)event.getParentEntries(), Items.SPORE_BLOSSOM, CreativeTabHelper.getFlowersForCreativeTab(event.getParameters().holders()), (arg_0, arg_1, arg_2) -> ((BuildCreativeModeTabContentsEvent)event).insertAfter(arg_0, arg_1, arg_2));
                CreativeTabHelper.getCustomFlowersForCreativeTab(event.getParameters().holders()).reversed().forEach(stack -> event.insertAfter(new ItemStack((ItemLike)BovinesItems.SNOWDROP), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                CreativeTabHelper.getCustomMushroomsForCreativeTab(event.getParameters().holders()).reversed().forEach(stack -> event.insertAfter(new ItemStack((ItemLike)Items.RED_MUSHROOM), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                CreativeTabHelper.getCustomMushroomBlocksForCreativeTab(event.getParameters().holders()).reversed().forEach(stack -> event.insertAfter(new ItemStack((ItemLike)Items.RED_MUSHROOM_BLOCK), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                event.insertAfter(new ItemStack((ItemLike)Items.HONEY_BLOCK), new ItemStack((ItemLike)BovinesItems.RICH_HONEY_BLOCK), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
                BovinesAndButtercupsNeoForge.insertAfter((Set<ItemStack>)event.getParentEntries(), Items.MILK_BUCKET, CreativeTabHelper.getNectarBowlsForCreativeTab(event.getParameters().holders()), (arg_0, arg_1, arg_2) -> ((BuildCreativeModeTabContentsEvent)event).insertAfter(arg_0, arg_1, arg_2));
                event.insertAfter(new ItemStack((ItemLike)Items.HONEY_BOTTLE), new ItemStack((ItemLike)BovinesItems.RICH_HONEY_BOTTLE), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                event.accept((ItemLike)BovinesItems.MOOBLOOM_SPAWN_EGG);
            } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                CreativeTabHelper.getFlowerCrownsForCreativeTab(event.getParameters().holders()).reversed().forEach(stack -> event.insertAfter(new ItemStack((ItemLike)Items.SADDLE), stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            } else if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
                event.insertAfter(new ItemStack((ItemLike)Items.HONEY_BLOCK), new ItemStack((ItemLike)BovinesItems.RICH_HONEY_BLOCK), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
            CreativeTabHelper.addEdibleBlocksToCreativeTabs(event.getParameters().holders(), event.getParentEntries().stream().toList(), event.getSearchEntries().stream().toList(), (ResourceKey<CreativeModeTab>)event.getTabKey(), (arg_0, arg_1) -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0, arg_1), (arg_0, arg_1) -> ((BuildCreativeModeTabContentsEvent)event).insertFirst(arg_0, arg_1), (arg_0, arg_1, arg_2) -> ((BuildCreativeModeTabContentsEvent)event).insertBefore(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> ((BuildCreativeModeTabContentsEvent)event).insertAfter(arg_0, arg_1, arg_2));
        }
    }

    @EventBusSubscriber(modid="bovinesandbuttercups", bus=EventBusSubscriber.Bus.GAME)
    public static class GameEvents {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            BovinesCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }

        @SubscribeEvent
        public static void onStartTracking(PlayerEvent.StartTracking event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living.hasData(BovinesAttachments.LOCKDOWN)) {
                    BovinesAndButtercups.getHelper().sendClientboundPacket(player, new SyncLockdownEffectsClientboundPacket(living.getId(), BovinesAndButtercups.getHelper().getLockdownAttachment(living), true));
                }
                if (living.hasData(BovinesAttachments.COW_VARIANT)) {
                    CowVariantAttachment attachment = (CowVariantAttachment)living.getData(BovinesAttachments.COW_VARIANT);
                    for (CowModelLayer layer : ((CowVariant)attachment.cowVariant().value()).configuration().layers()) {
                        for (TextureModifierFactory<?> modifier : layer.textureModifiers()) {
                            modifier.init((Entity)living);
                        }
                    }
                    BovinesAndButtercups.getHelper().sendClientboundPacket(player, new SyncCowVariantClientboundPacket(living.getId(), BovinesAndButtercups.getHelper().getCowVariantAttachment(living), true));
                }
                if (living.hasData(BovinesAttachments.MOOSHROOM_EXTRAS)) {
                    BovinesAndButtercups.getHelper().sendClientboundPacket(player, new SyncMooshroomExtrasClientboundPacket(living.getId(), BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment(living), true));
                }
            }
        }

        @SubscribeEvent
        public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
            Level level = event.getLevel();
            Entity entity = event.getEntity();
            if (entity instanceof Bee) {
                Bee bee = (Bee)entity;
                PollinateMoobloomGoal pollinateGoal = new PollinateMoobloomGoal(bee);
                bee.getGoalSelector().addGoal(3, (Goal)pollinateGoal);
                bee.getGoalSelector().addGoal(3, (Goal)new MoveToMoobloomGoal(bee));
                ((BeeGoalAccess)bee).bovinesandbuttercups$setPollinateMoobloomGoal(pollinateGoal);
            }
            if (level.isClientSide) {
                return;
            }
            Optional attachment = entity.getExistingData(BovinesAttachments.COW_VARIANT);
            if (entity.getType() == EntityType.MOOSHROOM) {
                if (attachment.isEmpty()) {
                    if (((MooshroomInitializedTypeAccess)entity).bovinesandbuttercups$initialType() != null) {
                        CowVariantAttachment.setCowVariant((LivingEntity)((MushroomCow)entity), MooshroomSpawnUtil.getMooshroomTypeFromMushroomType((LevelAccessor)level, ((MooshroomInitializedTypeAccess)entity).bovinesandbuttercups$initialType()));
                    } else if (MooshroomSpawnUtil.getTotalSpawnWeight((LevelAccessor)level, entity.blockPosition()) > 0) {
                        CowVariantAttachment.setCowVariant((LivingEntity)((MushroomCow)entity), MooshroomSpawnUtil.getMooshroomSpawnTypeDependingOnBiome((LevelAccessor)level, entity.blockPosition(), level.getRandom()));
                    } else {
                        CowVariantAttachment.setCowVariant((LivingEntity)((MushroomCow)entity), MooshroomSpawnUtil.getMostCommonMooshroomSpawnType((LevelAccessor)level, ((MushroomCow)entity).getVariant()));
                    }
                    CowVariantAttachment.sync((LivingEntity)((MushroomCow)entity));
                }
                ((MooshroomInitializedTypeAccess)entity).bovinesandbuttercups$clearInitialType();
            }
        }

        @SubscribeEvent
        public static void onBabyEntitySpawn(BabyEntitySpawnEvent event) {
            Mob parentA = event.getParentA();
            Mob parentB = event.getParentB();
            AgeableMob child = event.getChild();
            if (parentA instanceof MushroomCow) {
                MushroomCow parentACow = (MushroomCow)parentA;
                if (parentB instanceof MushroomCow) {
                    MushroomCow parentBCow = (MushroomCow)parentB;
                    if (child instanceof MushroomCow) {
                        MushroomCow childCow = (MushroomCow)child;
                        Pair<Holder<CowVariant<MooshroomConfiguration>>, Optional<Holder<CowVariant<MooshroomConfiguration>>>> pair = MooshroomChildTypeUtil.chooseMooshroomBabyVariant(parentACow, parentBCow, childCow, event.getCausedByPlayer());
                        if (pair == null) {
                            return;
                        }
                        CowVariantAttachment.setCowVariant((LivingEntity)child, (Holder)pair.getFirst(), (Optional)pair.getSecond());
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Entity target = event.getTarget();
            ItemStack handItem = event.getEntity().getItemInHand(event.getHand());
            if (target.getType() == EntityType.MOOSHROOM) {
                InteractionResult result;
                if (handItem.is(Tags.Items.TOOLS_SHEAR) && event.getEntity().hasData(BovinesAttachments.MOOSHROOM_EXTRAS) && !((MooshroomExtrasAttachment)event.getEntity().getData(BovinesAttachments.MOOSHROOM_EXTRAS)).allowShearing()) {
                    event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
                }
                if ((result = SnowLayerUtil.removeSnowIfShovel(target, event.getEntity(), event.getHand(), handItem)) != InteractionResult.PASS) {
                    event.setCancellationResult(result);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingConversion(LivingConversionEvent.Pre event) {
            if (event.getEntity().getType() == EntityType.MOOSHROOM && event.getEntity().hasData(BovinesAttachments.MOOSHROOM_EXTRAS) && !((MooshroomExtrasAttachment)event.getEntity().getData(BovinesAttachments.MOOSHROOM_EXTRAS)).allowConversion()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLivingTick(EntityTickEvent.Post event) {
            Object lockdownEffectsToUpdate;
            LivingEntity living;
            Entity entity;
            if (!event.getEntity().level().isClientSide() && (entity = event.getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(BovinesEffects.LOCKDOWN)) {
                lockdownEffectsToUpdate = new HashMap();
                living.getExistingData(BovinesAttachments.LOCKDOWN).ifPresent(arg_0 -> GameEvents.lambda$onLivingTick$1((HashMap)lockdownEffectsToUpdate, arg_0));
                ((LockdownAttachment)living.getData(BovinesAttachments.LOCKDOWN)).setLockdownMobEffects((Map<Holder<MobEffect>, Integer>)lockdownEffectsToUpdate);
                LockdownAttachment.sync(living);
            }
            if (event.getEntity().getType() == EntityType.MOOSHROOM && (lockdownEffectsToUpdate = event.getEntity()) instanceof MushroomCow) {
                MushroomCow mooshroom = (MushroomCow)lockdownEffectsToUpdate;
                MooshroomExtrasAttachment attachment = BovinesAndButtercups.getHelper().getMooshroomExtrasAttachment((LivingEntity)mooshroom);
                if (!attachment.hasSnow() && WeatherUtil.isInSnowyWeather((Entity)mooshroom) && !attachment.snowLayerPersistent() && !mooshroom.level().isClientSide() && mooshroom.getRandom().nextFloat() < 0.4f) {
                    BovinesAndButtercups.getHelper().setMooshroomExtrasAttachment((LivingEntity)mooshroom, new MooshroomExtrasAttachment(true, false, attachment.allowShearing(), attachment.allowConversion()));
                    MooshroomExtrasAttachment.sync((LivingEntity)mooshroom);
                }
                if (attachment.hasSnow() && !attachment.snowLayerPersistent() && mooshroom.level().getBiome(mooshroom.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS) && !mooshroom.level().isClientSide() && mooshroom.getRandom().nextFloat() < 0.4f) {
                    BovinesAndButtercups.getHelper().setMooshroomExtrasAttachment((LivingEntity)mooshroom, new MooshroomExtrasAttachment(false, false, attachment.allowShearing(), attachment.allowConversion()));
                    MooshroomExtrasAttachment.sync((LivingEntity)mooshroom);
                }
            }
            if (event.getEntity().hasData(BovinesAttachments.COW_VARIANT) && ((CowVariantAttachment)event.getEntity().getData(BovinesAttachments.COW_VARIANT)).cowVariant().isBound()) {
                ((CowVariant)((CowVariantAttachment)event.getEntity().getData(BovinesAttachments.COW_VARIANT)).cowVariant().value()).configuration().tick(event.getEntity());
            }
            if ((entity = event.getEntity()) instanceof Bee) {
                Bee bee = (Bee)entity;
                if (!event.getEntity().level().isClientSide() && ((BeeGoalAccess)event.getEntity()).bovinesandbuttercups$getPollinateMoobloomGoal() != null) {
                    ((BeeGoalAccess)bee).bovinesandbuttercups$getPollinateMoobloomGoal().tickCooldown();
                }
            }
        }

        @SubscribeEvent
        public static void onMobEffectAdded(MobEffectEvent.Added event) {
            LockdownAttachment attachment;
            MobEffectInstance effect;
            LivingEntity entity;
            block8: {
                block9: {
                    block7: {
                        entity = event.getEntity();
                        effect = event.getEffectInstance();
                        if (!effect.is(BovinesEffects.LOCKDOWN)) {
                            return;
                        }
                        attachment = (LockdownAttachment)entity.getData(BovinesAttachments.LOCKDOWN);
                        if (entity.level().isClientSide() || ((MobEffectInstanceLockdownDataAccess)effect).bovinesandbuttercups$getLockdownData().isEmpty()) break block7;
                        for (LockdownData data : ((MobEffectInstanceLockdownDataAccess)effect).bovinesandbuttercups$getLockdownData()) {
                            attachment.addLockdownMobEffect(data.linkedEffect(), data.duration().orElse(effect.getDuration()));
                        }
                        break block8;
                    }
                    if (entity.level().isClientSide()) break block8;
                    if (attachment.effects().isEmpty()) break block9;
                    if (!attachment.effects().values().stream().allMatch(value -> value < effect.getDuration())) break block8;
                }
                Optional randomEffect = Util.getRandomSafe(BuiltInRegistries.MOB_EFFECT.registryKeySet().stream().map(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).getOrThrow(arg_0)).filter(holder -> holder.isBound() && !holder.is(BovinesEffects.LOCKDOWN) && ((MobEffect)holder.value()).isEnabled(entity.level().enabledFeatures())).toList(), (RandomSource)entity.level().getRandom());
                randomEffect.ifPresent(entry -> attachment.addLockdownMobEffect((Holder<MobEffect>)entry, effect.getDuration()));
            }
            if (!entity.level().isClientSide() && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (effect.getEffect().is(BovinesEffects.LOCKDOWN) && !attachment.effects().isEmpty()) {
                    attachment.effects().forEach((effect1, duration) -> {
                        if (!entity.hasEffect(effect1)) {
                            return;
                        }
                        LockEffectTrigger.INSTANCE.trigger(serverPlayer, (Holder<MobEffect>)effect1);
                    });
                }
            }
            LockdownAttachment.sync(entity);
        }

        @SubscribeEvent
        public static void onMobEffectRemoved(MobEffectEvent.Remove event) {
            if (event.getEffectInstance() == null || !event.getEffectInstance().getEffect().is(BovinesEffects.LOCKDOWN)) {
                return;
            }
            Optional attachment = event.getEntity().getExistingData(BovinesAttachments.LOCKDOWN);
            if (attachment.isPresent()) {
                ((LockdownAttachment)attachment.get()).effects().clear();
                LockdownAttachment.sync(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onMobEffectExpired(MobEffectEvent.Expired event) {
            if (event.getEffectInstance() == null || !event.getEffectInstance().getEffect().is(BovinesEffects.LOCKDOWN)) {
                return;
            }
            Optional attachment = event.getEntity().getExistingData(BovinesAttachments.LOCKDOWN);
            if (attachment.isPresent()) {
                ((LockdownAttachment)attachment.get()).effects().clear();
                LockdownAttachment.sync(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void changeMobEffectApplicability(MobEffectEvent.Applicable event) {
            LivingEntity entity = event.getEntity();
            Optional attachment = event.getEntity().getExistingData(BovinesAttachments.LOCKDOWN);
            if (attachment.isPresent() && ((LockdownAttachment)attachment.get()).effects().containsKey(event.getEffectInstance().getEffect())) {
                if (!entity.level().isClientSide && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    PreventEffectTrigger.INSTANCE.trigger(serverPlayer, (Holder<MobEffect>)event.getEffectInstance().getEffect());
                }
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        }

        @SubscribeEvent
        public static void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!(entity instanceof Moobloom) && entity.hasData(BovinesAttachments.COW_VARIANT)) {
                    CowVariantAttachment attachment = (CowVariantAttachment)entity.getData(BovinesAttachments.COW_VARIANT);
                    if (!attachment.cowVariant().isBound() || !((CowVariant)attachment.cowVariant().value()).configuration().allowsConversion(entity)) {
                        return;
                    }
                    if (attachment.previousCowVariant().isEmpty()) {
                        if (((CowVariant)attachment.cowVariant().value()).configuration().settings().thunderConverts().isEmpty()) {
                            return;
                        }
                        List compatibleList = ((CowVariant)attachment.cowVariant().value()).configuration().settings().filterThunderConverts(((CowVariant)attachment.cowVariant().value()).type());
                        int totalWeight = 0;
                        if (compatibleList.size() == 1) {
                            CowVariantAttachment.setCowVariant(living, (Holder)compatibleList.getFirst().data(), attachment.cowVariant());
                            CowVariantAttachment.sync(living);
                            BovinesAndButtercups.convertedByBovines = true;
                        } else if (!compatibleList.isEmpty()) {
                            for (WeightedEntry.Wrapper cct : compatibleList) {
                                if ((totalWeight -= cct.weight().asInt()) > 0) continue;
                                CowVariantAttachment.setCowVariant(living, (Holder)cct.data(), attachment.cowVariant());
                                CowVariantAttachment.sync(living);
                                BovinesAndButtercups.convertedByBovines = true;
                                break;
                            }
                        }
                    } else {
                        CowVariantAttachment.setCowVariant(living, attachment.previousCowVariant().get());
                        CowVariantAttachment.sync(living);
                        BovinesAndButtercups.convertedByBovines = true;
                    }
                }
            }
        }

        private static /* synthetic */ void lambda$onLivingTick$1(HashMap lockdownEffectsToUpdate, LockdownAttachment attachment) {
            attachment.effects().forEach((effect, integer) -> {
                if (integer > 0) {
                    integer = integer - 1;
                    lockdownEffectsToUpdate.put(effect, integer);
                } else if (integer == -1) {
                    lockdownEffectsToUpdate.put(effect, -1);
                }
            });
        }
    }
}

