/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowType;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.codec.BovinesCodecs;
import house.greenhouse.bovinesandbuttercups.api.variant.CowModelLayer;
import house.greenhouse.bovinesandbuttercups.api.variant.model.CowModelType;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public interface CowConfiguration {
    default public void tick(Entity entity) {
    }

    default public CowModelType model() {
        return null;
    }

    default public List<CowModelLayer> layers() {
        return List.of();
    }

    default public boolean hasSnow(Entity entity) {
        return false;
    }

    default public boolean allowsConversion(Entity entity) {
        return false;
    }

    @Nullable
    default public Settings settings() {
        return null;
    }

    public record Settings(Optional<ResourceLocation> cowTexture, SimpleWeightedRandomList<HolderSet<Biome>> biomes, SimpleWeightedRandomList<Holder<CowVariant<?>>> thunderConverts, Optional<ParticleOptions> particle) {
        public static final MapCodec<Settings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("texture_location").forGetter(Settings::cowTexture), (App)BovinesCodecs.weightedEntryCodec(RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME), "biomes").optionalFieldOf("natural_spawns", (Object)SimpleWeightedRandomList.empty()).forGetter(Settings::biomes), (App)BovinesCodecs.weightedEntryCodec(CowVariant.CODEC, "type").optionalFieldOf("thunder_conversion_types", (Object)SimpleWeightedRandomList.empty()).forGetter(Settings::thunderConverts), (App)ParticleTypes.CODEC.optionalFieldOf("particle").forGetter(Settings::particle)).apply((Applicative)instance, Settings::new));

        public <C extends CowConfiguration, T extends CowType<C>> List<WeightedEntry.Wrapper<Holder<CowVariant<C>>>> filterThunderConverts(T type) {
            return this.thunderConverts.unwrap().stream().filter(holderWrapper -> {
                boolean bl;
                boolean bl2 = bl = ((Holder)holderWrapper.data()).isBound() && ((CowVariant)((Holder)holderWrapper.data()).value()).type() == type;
                if (!bl) {
                    BovinesAndButtercups.LOG.error("Attempted to add cow variant '{}', which does not have a type of '{}' to thunder conversion list.", ((Holder)holderWrapper.data()).unwrapKey().map(key -> key.location()).orElse(null), (Object)BovinesRegistries.COW_TYPE.getKey((Object)type));
                }
                return bl;
            }).toList();
        }
    }
}

