/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CowType<C extends CowConfiguration> {
    public static final Codec<Holder<CowType<?>>> CODEC = RegistryFixedCodec.create(BovinesRegistryKeys.COW_TYPE);
    private final MapCodec<CowVariant<C>> configuredCodec = RecordCodecBuilder.mapCodec(inst -> inst.group((App)codec.forGetter(CowVariant::configuration)).apply((Applicative)inst, ctc -> new CowVariant<CowConfiguration>(this, (CowConfiguration)ctc)));
    private final List<EntityType<?>> entityTypes;
    private final ResourceKey<CowVariant<?>> defaultKey;
    private final String fallbackTexturePath;
    private final Function<RegistryOps.RegistryInfoLookup, C> defaultConfigFunction;
    private C defaultConfig;

    public CowType(MapCodec<C> codec, List<EntityType<?>> entityTypes, ResourceKey<CowVariant<?>> defaultKey, String fallbackTexturePath, Function<RegistryOps.RegistryInfoLookup, C> defaultConfigFunction) {
        this.entityTypes = entityTypes;
        this.defaultKey = defaultKey;
        this.fallbackTexturePath = fallbackTexturePath;
        this.defaultConfigFunction = defaultConfigFunction;
    }

    public MapCodec<CowVariant<C>> cowCodec() {
        return this.configuredCodec;
    }

    public String fallbackTexturePath() {
        return this.fallbackTexturePath;
    }

    public boolean isApplicable(Entity entity) {
        return this.isApplicable(entity.getType());
    }

    public boolean isApplicable(EntityType<?> entityType) {
        return this.entityTypes.contains(entityType);
    }

    public ResourceKey<CowVariant<?>> defaultKey() {
        return this.defaultKey;
    }

    @Nullable
    public C defaultConfig() {
        return this.defaultConfig;
    }

    @ApiStatus.Internal
    public void setFromRegistries(RegistryAccess registryAccess) {
        this.defaultConfig = ((CowVariant)registryAccess.lookupOrThrow(BovinesRegistryKeys.COW_VARIANT).getOrThrow(this.defaultKey).value()).configuration();
    }

    public C createDefaultConfig(RegistryOps.RegistryInfoLookup lookup) {
        this.defaultConfig = (CowConfiguration)this.defaultConfigFunction.apply(lookup);
        return this.defaultConfig;
    }
}

