/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowType;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.content.data.configuration.MooshroomConfiguration;
import house.greenhouse.bovinesandbuttercups.network.clientbound.SyncCowVariantClientboundPacket;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import org.jetbrains.annotations.Nullable;

public record CowVariantAttachment(Holder<CowVariant<?>> cowVariant, Optional<Holder<CowVariant<?>>> previousCowVariant) {
    public static final ResourceLocation ID = BovinesAndButtercups.asResource("cow_variant");
    public static final Codec<CowVariantAttachment> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CowVariant.CODEC.fieldOf("current").forGetter(CowVariantAttachment::cowVariant), (App)CowVariant.CODEC.optionalFieldOf("previous").forGetter(CowVariantAttachment::previousCowVariant)).apply((Applicative)inst, CowVariantAttachment::new));
    public static final Codec<CowVariantAttachment> CODEC = Codec.either(CowVariant.CODEC, DIRECT_CODEC).flatComapMap(either -> (CowVariantAttachment)either.map(current -> new CowVariantAttachment((Holder<CowVariant<?>>)current, Optional.empty()), Function.identity()), attachment -> {
        if (attachment.previousCowVariant().isEmpty()) {
            return DataResult.success((Object)Either.left(attachment.cowVariant()));
        }
        return DataResult.success((Object)Either.right((Object)attachment));
    });

    @Nullable
    public static <C extends CowConfiguration, T extends CowType<C>> CowVariant<C> getCowVariantFromEntity(LivingEntity living, T cowVariant) {
        Holder<CowVariant<C>> type = CowVariantAttachment.getCowVariantHolderFromEntity(living, cowVariant);
        if (type != null && type.isBound()) {
            return (CowVariant)type.value();
        }
        return null;
    }

    @Nullable
    public static <C extends CowConfiguration, T extends CowType<C>> Holder<CowVariant<C>> getCowVariantHolderFromEntity(LivingEntity living, T cowVariant) {
        CowVariantAttachment attachment = BovinesAndButtercups.getHelper().getCowVariantAttachment(living);
        if (attachment != null && attachment.cowVariant.isBound() && ((CowVariant)attachment.cowVariant.value()).type() == cowVariant) {
            return attachment.cowVariant;
        }
        return null;
    }

    @Nullable
    public static <C extends CowConfiguration, T extends CowType<C>> CowVariant<C> getPreviousCowVariantFromEntity(LivingEntity living, T cowVariant) {
        Holder<CowVariant<C>> type = CowVariantAttachment.getPreviousCowVariantHolderFromEntity(living, cowVariant);
        if (type != null && type.isBound()) {
            return (CowVariant)type.value();
        }
        return null;
    }

    @Nullable
    public static <C extends CowConfiguration, T extends CowType<C>> Holder<CowVariant<C>> getPreviousCowVariantHolderFromEntity(LivingEntity living, T cowVariant) {
        CowVariantAttachment attachment = BovinesAndButtercups.getHelper().getCowVariantAttachment(living);
        if (attachment != null && attachment.previousCowVariant.isPresent() && attachment.previousCowVariant.get().isBound() && ((CowVariant)attachment.previousCowVariant.get().value()).type() == cowVariant) {
            return attachment.previousCowVariant.get();
        }
        return null;
    }

    public static <C extends CowConfiguration> void setCowVariant(LivingEntity entity, Holder<CowVariant<C>> cowVariant) {
        CowVariantAttachment.setCowVariant(entity, cowVariant, Optional.empty());
    }

    public static <C extends CowConfiguration> void setCowVariant(LivingEntity entity, Holder<CowVariant<C>> cowVariant, Holder<CowVariant<C>> previousCowVariant) {
        CowVariantAttachment.setCowVariant(entity, cowVariant, Optional.of(previousCowVariant));
    }

    public static <C extends CowConfiguration> void setCowVariant(LivingEntity entity, Holder<CowVariant<C>> cowVariant, Optional<Holder<CowVariant<C>>> previousCowVariant) {
        if (cowVariant.isBound() && ((CowVariant)cowVariant.value()).type().isApplicable((Entity)entity)) {
            MooshroomConfiguration mc;
            Object c;
            CowVariantAttachment previousAttachment = BovinesAndButtercups.getHelper().getCowVariantAttachment(entity);
            Optional<Holder<CowVariant<?>>> previousVariant = previousAttachment != null && previousAttachment.previousCowVariant().isPresent() ? BovinesAndButtercups.getHelper().getCowVariantAttachment(entity).previousCowVariant() : previousCowVariant.map(holder -> holder);
            BovinesAndButtercups.getHelper().setCowVariantAttachment(entity, new CowVariantAttachment(cowVariant, previousVariant));
            if (entity.getType() == EntityType.MOOSHROOM && (c = ((CowVariant)cowVariant.value()).configuration()) instanceof MooshroomConfiguration && (mc = (MooshroomConfiguration)c).vanillaType().isPresent()) {
                ((MushroomCow)entity).setVariant(mc.vanillaType().get());
            }
        }
    }

    public static void sync(LivingEntity entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        BovinesAndButtercups.getHelper().sendTrackingClientboundPacket((Entity)entity, new SyncCowVariantClientboundPacket(entity.getId(), BovinesAndButtercups.getHelper().getCowVariantAttachment(entity), false));
    }

    public static void syncToPlayer(LivingEntity entity, ServerPlayer player) {
        if (entity.level().isClientSide()) {
            return;
        }
        BovinesAndButtercups.getHelper().sendClientboundPacket(player, new SyncCowVariantClientboundPacket(entity.getId(), BovinesAndButtercups.getHelper().getCowVariantAttachment(entity), false));
    }
}

