/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistryKeys;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public record CustomMushroomType(ResourceLocation itemModel, Optional<ResourceLocation> hugeBlockItemModel, boolean hasHugeBlock, boolean hasPotted, Optional<ResourceKey<StructureTemplatePool>> hugeMushroomStructurePool, boolean randomlyRotateHugeStructure) {
    public static final Codec<CustomMushroomType> DIRECT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("item_model").forGetter(CustomMushroomType::itemModel), (App)ResourceLocation.CODEC.optionalFieldOf("huge_block_item_model").forGetter(CustomMushroomType::hugeBlockItemModel), (App)Codec.BOOL.optionalFieldOf("has_huge_block", (Object)true).forGetter(CustomMushroomType::hasHugeBlock), (App)Codec.BOOL.optionalFieldOf("has_potted", (Object)true).forGetter(CustomMushroomType::hasPotted), (App)ResourceKey.codec((ResourceKey)Registries.TEMPLATE_POOL).optionalFieldOf("huge_mushroom_template_pool").forGetter(CustomMushroomType::hugeMushroomStructurePool), (App)Codec.BOOL.optionalFieldOf("randomly_rotate_huge_mushroom", (Object)false).forGetter(CustomMushroomType::randomlyRotateHugeStructure)).apply((Applicative)builder, CustomMushroomType::new));
    public static final Codec<Holder<CustomMushroomType>> CODEC = RegistryFixedCodec.create(BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE);
    public static final ResourceKey<CustomMushroomType> MISSING_KEY = ResourceKey.create(BovinesRegistryKeys.CUSTOM_MUSHROOM_TYPE, (ResourceLocation)BovinesAndButtercups.asResource("missing_mushroom"));
    public static final CustomMushroomType MISSING = new CustomMushroomType(BovinesAndButtercups.asResource("missing_mushroom"), Optional.of(BovinesAndButtercups.asResource("missing_mushorom_block")), true, true, Optional.empty(), false);

    public CustomMushroomType {
        if (hasHugeBlock && hugeBlockItemModel.isEmpty()) {
            throw new NullPointerException("Custom Mushroom with 'has_huge_block' set to true must have 'huge_block_item_model' set.");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomMushroomType)) {
            return false;
        }
        CustomMushroomType other = (CustomMushroomType)obj;
        return other.hugeMushroomStructurePool.equals(this.hugeMushroomStructurePool);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hugeMushroomStructurePool);
    }
}

