/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.api.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.api.variant.modifier.TextureModifierFactory;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public record CowModelLayer(ResourceLocation textureLocation, List<TextureModifierFactory<?>> textureModifiers) {
    public static final Codec<CowModelLayer> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("texture_location").forGetter(CowModelLayer::textureLocation), (App)TextureModifierFactory.CODEC.listOf().optionalFieldOf("texture_modifiers", List.of()).forGetter(CowModelLayer::textureModifiers)).apply((Applicative)inst, CowModelLayer::new));

    public void tickTextureModifiers(Entity entity) {
        this.textureModifiers.forEach(textureModifierFactory -> textureModifierFactory.tick(entity));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CowModelLayer)) {
            return false;
        }
        CowModelLayer other = (CowModelLayer)obj;
        return other.textureLocation.equals((Object)this.textureLocation) && other.textureModifiers.equals(this.textureModifiers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.textureLocation, this.textureModifiers);
    }
}

