/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client;

import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.client.api.RenderStateObject;
import house.greenhouse.bovinesandbuttercups.client.platform.BovinesClientHelper;
import house.greenhouse.bovinesandbuttercups.client.renderer.item.FlowerCrownItemRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.item.select.BovinesSelectProperties;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.special.SpecialModelRenderers;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class BovinesAndButtercupsClient {
    private static final HashSet<ResourceLocation> LOADED_COW_TEXTURES = new HashSet();
    private static final HashSet<ResourceLocation> FAILED_COW_TEXTURES = new HashSet();
    private static BovinesClientHelper clientHelper;

    public static void init(BovinesClientHelper helper) {
        clientHelper = helper;
        RenderStateObject.registerAll();
        BovinesSelectProperties.registerAll();
        BovinesAndButtercupsClient.registerItemRenderers();
    }

    public static void registerItemRenderers() {
        SpecialModelRenderers.ID_MAPPER.put((Object)FlowerCrownItemRenderer.Unbaked.ID, FlowerCrownItemRenderer.Unbaked.MAP_CODEC);
    }

    public static void clearCowTextureCache() {
        LOADED_COW_TEXTURES.clear();
        FAILED_COW_TEXTURES.clear();
    }

    public static ResourceLocation getCachedTextures(Holder<CowVariant<?>> cowVariant, ResourceLocation original) {
        ReloadableTexture reloadableTexture;
        if (((CowVariant)cowVariant.value()).configuration().settings() == null || ((CowVariant)cowVariant.value()).type().defaultConfig().settings() == null) {
            return original;
        }
        ResourceLocation remappedLocation = BovinesAndButtercupsClient.getTextureFromCowType(((CowVariant)cowVariant.value()).configuration(), ((CowVariant)cowVariant.value()).type().fallbackTexturePath(), cowVariant.unwrapKey().orElse(((CowVariant)cowVariant.value()).type().defaultKey()).location());
        if (LOADED_COW_TEXTURES.contains(remappedLocation)) {
            return remappedLocation;
        }
        if (FAILED_COW_TEXTURES.contains(remappedLocation)) {
            if (((CowVariant)cowVariant.value()).type().defaultConfig().settings() == null) {
                return original;
            }
            return BovinesAndButtercupsClient.getTextureFromCowType(((CowVariant)cowVariant.value()).type().defaultConfig(), ((CowVariant)cowVariant.value()).type().fallbackTexturePath(), ((CowVariant)cowVariant.value()).type().defaultKey().location());
        }
        AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(remappedLocation);
        if (!(abstractTexture instanceof ReloadableTexture) || !(reloadableTexture = (ReloadableTexture)abstractTexture).resourceId().equals((Object)MissingTextureAtlasSprite.getLocation())) {
            LOADED_COW_TEXTURES.add(remappedLocation);
            return remappedLocation;
        }
        FAILED_COW_TEXTURES.add(remappedLocation);
        return BovinesAndButtercupsClient.getTextureFromCowType(((CowVariant)cowVariant.value()).type().defaultConfig(), ((CowVariant)cowVariant.value()).type().fallbackTexturePath(), ((CowVariant)cowVariant.value()).type().defaultKey().location());
    }

    private static ResourceLocation getTextureFromCowType(CowConfiguration configuration, String fallbackTexturePath, ResourceLocation originalLocation) {
        return configuration.settings().cowTexture().map(texture -> texture.withPath(s -> "textures/entity/" + s + ".png")).orElseGet(() -> originalLocation.withPath(str -> "textures/entity/" + fallbackTexturePath.replace("%s", (CharSequence)str) + ".png"));
    }

    public static BovinesClientHelper getHelper() {
        return clientHelper;
    }
}

