/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client;

import house.greenhouse.bovinesandbuttercups.client.BovinesAndButtercupsClient;
import house.greenhouse.bovinesandbuttercups.client.LockdownClientEffectExtensions;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.BovinesModelSetTypes;
import house.greenhouse.bovinesandbuttercups.client.particle.BloomParticle;
import house.greenhouse.bovinesandbuttercups.client.particle.ModelLocationParticle;
import house.greenhouse.bovinesandbuttercups.client.particle.ShroomParticle;
import house.greenhouse.bovinesandbuttercups.client.platform.BovinesClientHelperNeoForge;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.CustomFlowerPotBlockRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.CustomFlowerRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.CustomHugeMushroomBlockRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.CustomMushroomPotBlockRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.CustomMushroomRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.PlaceableEdibleBlockRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.MoobloomRenderer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer.CowLayersLayer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer.FlowerCrownLayer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.layer.MooshroomDatapackMushroomLayer;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.CustomCowModelLayers;
import house.greenhouse.bovinesandbuttercups.client.renderer.entity.model.FlowerCrownModel;
import house.greenhouse.bovinesandbuttercups.client.renderer.item.FlowerCrownItemRenderer;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesModelLayers;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesModelSetUtil;
import house.greenhouse.bovinesandbuttercups.client.util.ClearTextureCacheReloadListener;
import house.greenhouse.bovinesandbuttercups.content.block.entity.BovinesBlockEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.effect.BovinesEffects;
import house.greenhouse.bovinesandbuttercups.content.entity.BovinesEntityTypes;
import house.greenhouse.bovinesandbuttercups.content.particle.BovinesParticleTypes;
import house.greenhouse.bovinesandbuttercups.mixin.neoforge.client.EntityRenderersEventAddLayersAccessor;
import house.greenhouse.bovinesandbuttercups.registry.BovinesRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MushroomCowRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@Mod(value="bovinesandbuttercups", dist={Dist.CLIENT})
public class BovinesAndButtercupsNeoForgeClient {
    public BovinesAndButtercupsNeoForgeClient(IEventBus eventBus) {
        BovinesAndButtercupsClient.init(new BovinesClientHelperNeoForge());
    }

    @EventBusSubscriber(modid="bovinesandbuttercups", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEvents {
        private static final Map<ResourceLocation, UnbakedModel> MODEL_CACHE = new HashMap<ResourceLocation, UnbakedModel>();

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            BovinesModelSetTypes.init();
        }

        @SubscribeEvent
        public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new ClearTextureCacheReloadListener());
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerMobEffect((IClientMobEffectExtensions)LockdownClientEffectExtensions.INSTANCE, new Holder[]{BovinesEffects.LOCKDOWN});
        }

        @SubscribeEvent
        public static void additionalModels(ModelEvent.RegisterAdditional event) {
            List<ResourceLocation> models = BovinesModelSetUtil.getModels(Minecraft.getInstance().getResourceManager(), Runnable::run).join();
            for (ResourceLocation entry : models) {
                UnbakedModel unbaked = BovinesModelSetUtil.getUnbakedModel(entry);
                if (unbaked == null) continue;
                unbaked.resolveDependencies(model -> {
                    event.register(model);
                    return null;
                });
                MODEL_CACHE.put(entry, unbaked);
            }
            event.register(FlowerCrownItemRenderer.BASE);
        }

        @SubscribeEvent
        public static void bakeModels(ModelEvent.ModifyBakingResult event) {
            List<ResourceLocation> models = BovinesModelSetUtil.getModels(Minecraft.getInstance().getResourceManager(), Runnable::run).join();
            for (ResourceLocation entry : models) {
                UnbakedModel unbaked = MODEL_CACHE.get(entry);
                if (unbaked == null) continue;
                event.getBakingResult().standaloneModels().put(entry, ModEvents.bakeModel(entry, unbaked, event.getTextureGetter(), event.getModelBakery()));
            }
            MODEL_CACHE.clear();
        }

        private static BakedModel bakeModel(ResourceLocation key, UnbakedModel model, final Function<Material, TextureAtlasSprite> textureGetter, ModelBakery bakery) {
            ModelBakery.TextureGetter getter = new ModelBakery.TextureGetter(){

                public TextureAtlasSprite get(ModelDebugName name, Material material) {
                    return (TextureAtlasSprite)textureGetter.apply(material);
                }

                public TextureAtlasSprite reportMissingReference(ModelDebugName name, String reference) {
                    return (TextureAtlasSprite)textureGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()));
                }
            };
            ModelBakery modelBakery = bakery;
            Objects.requireNonNull(modelBakery);
            return UnbakedModel.bakeWithTopModelValues((UnbakedModel)model, (ModelBaker)new ModelBakery.ModelBakerImpl(modelBakery, getter, () -> ((ResourceLocation)key).toString()), (ModelState)BlockModelRotation.X0_Y0);
        }

        @SubscribeEvent
        public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BovinesModelLayers.MOOBLOOM_MODEL_LAYER, CowModel::createBodyLayer);
            event.registerLayerDefinition(BovinesModelLayers.BABY_MOOBLOOM_MODEL_LAYER, () -> CowModel.createBodyLayer().apply(CowModel.BABY_TRANSFORMER));
            event.registerLayerDefinition(BovinesModelLayers.HIGHLAND_MODEL_LAYER, CustomCowModelLayers::createHighland);
            event.registerLayerDefinition(BovinesModelLayers.BABY_HIGHLAND_MODEL_LAYER, () -> CustomCowModelLayers.createHighland().apply(CowModel.BABY_TRANSFORMER));
            event.registerLayerDefinition(BovinesModelLayers.BUFFALO_MODEL_LAYER, CustomCowModelLayers::createBuffalo);
            event.registerLayerDefinition(BovinesModelLayers.BABY_BUFFALO_MODEL_LAYER, () -> CustomCowModelLayers.createBuffalo().apply(CowModel.BABY_TRANSFORMER));
            event.registerLayerDefinition(BovinesModelLayers.OX_MODEL_LAYER, CustomCowModelLayers::createOx);
            event.registerLayerDefinition(BovinesModelLayers.BABY_OX_MODEL_LAYER, () -> CustomCowModelLayers.createOx().apply(CowModel.BABY_TRANSFORMER));
            event.registerLayerDefinition(BovinesModelLayers.FLAT_MODEL_LAYER, CustomCowModelLayers::createFlat);
            event.registerLayerDefinition(BovinesModelLayers.BABY_FLAT_MODEL_LAYER, () -> CustomCowModelLayers.createFlat().apply(CowModel.BABY_TRANSFORMER));
            event.registerLayerDefinition(BovinesModelLayers.FLOWER_CROWN_MODEL_LAYER, () -> FlowerCrownModel.createLayer(new CubeDeformation(0.75f)));
            event.registerLayerDefinition(BovinesModelLayers.PIGLIN_FLOWER_CROWN_MODEL_LAYER, () -> FlowerCrownModel.createLayer(new CubeDeformation(1.5f, 0.5f, 0.5f)));
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(BovinesEntityTypes.MOOBLOOM, MoobloomRenderer::new);
            event.registerBlockEntityRenderer(BovinesBlockEntityTypes.CUSTOM_FLOWER, CustomFlowerRenderer::new);
            event.registerBlockEntityRenderer(BovinesBlockEntityTypes.CUSTOM_MUSHROOM, CustomMushroomRenderer::new);
            event.registerBlockEntityRenderer(BovinesBlockEntityTypes.POTTED_CUSTOM_FLOWER, CustomFlowerPotBlockRenderer::new);
            event.registerBlockEntityRenderer(BovinesBlockEntityTypes.POTTED_CUSTOM_MUSHROOM, CustomMushroomPotBlockRenderer::new);
            event.registerBlockEntityRenderer(BovinesBlockEntityTypes.CUSTOM_MUSHROOM_BLOCK, CustomHugeMushroomBlockRenderer::new);
            event.registerBlockEntityRenderer(BovinesBlockEntityTypes.PLACEABLE_EDIBLE, PlaceableEdibleBlockRenderer::new);
        }

        @SubscribeEvent
        public static void registerRenderLayers(EntityRenderersEvent.AddLayers event) {
            MushroomCowRenderer mushroomCowRenderer = (MushroomCowRenderer)event.getRenderer(EntityType.MOOSHROOM);
            mushroomCowRenderer.addLayer(new CowLayersLayer(mushroomCowRenderer));
            mushroomCowRenderer.addLayer(new MooshroomDatapackMushroomLayer(mushroomCowRenderer, event.getContext().getBlockRenderDispatcher()));
            ArrayList<LivingEntityRenderer> renderers = new ArrayList<LivingEntityRenderer>();
            for (PlayerSkin.Model skin : event.getSkins()) {
                EntityRenderer entityRenderer2 = event.getSkin(skin);
                if (!(entityRenderer2 instanceof LivingEntityRenderer)) continue;
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer2;
                livingRenderer.addLayer(new FlowerCrownLayer(livingRenderer, (Function<ModelLayerLocation, ModelPart>)((Function<Object, Object>)modelLayerLocation -> event.getContext().bakeLayer((ModelLayerLocation)modelLayerLocation)), event.getContext().getModelManager()));
                renderers.add(livingRenderer);
            }
            ((EntityRenderersEventAddLayersAccessor)event).bovinesandbuttercups$getRenderers().forEach((entityType, entityRenderer) -> {
                EntityModel model;
                LivingEntityRenderer livingRenderer;
                if (entityRenderer instanceof LivingEntityRenderer && !renderers.contains(livingRenderer = (LivingEntityRenderer)entityRenderer) && ((model = livingRenderer.getModel()) instanceof HumanoidModel || model instanceof IllagerModel || model instanceof VillagerModel)) {
                    livingRenderer.addLayer(new FlowerCrownLayer(livingRenderer, (Function<ModelLayerLocation, ModelPart>)((Function<Object, Object>)modelLayerLocation -> event.getContext().bakeLayer((ModelLayerLocation)modelLayerLocation)), event.getContext().getModelManager()));
                }
            });
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpecial(BovinesParticleTypes.MODEL_LOCATION, (ParticleProvider)new ModelLocationParticle.Provider());
            event.registerSpriteSet(BovinesParticleTypes.BLOOM, BloomParticle.Provider::new);
            event.registerSpriteSet(BovinesParticleTypes.SHROOM, ShroomParticle.Provider::new);
        }
    }

    @EventBusSubscriber(modid="bovinesandbuttercups", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class GameEvents {
        @SubscribeEvent
        public static void onLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
            BovinesRegistries.COW_TYPE.forEach(cowType -> cowType.setFromRegistries(Minecraft.getInstance().level.registryAccess()));
        }
    }
}

