/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.api.CowConfiguration;
import house.greenhouse.bovinesandbuttercups.api.CowVariant;
import house.greenhouse.bovinesandbuttercups.api.attachment.CowVariantAttachment;
import house.greenhouse.bovinesandbuttercups.api.variant.model.BovinesCowModelTypes;
import house.greenhouse.bovinesandbuttercups.api.variant.model.CowModelType;
import house.greenhouse.bovinesandbuttercups.client.api.CowVariantRenderState;
import house.greenhouse.bovinesandbuttercups.client.api.RenderStateObject;
import house.greenhouse.bovinesandbuttercups.mixin.client.AgeableMobRendererAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractCowTypeRenderState<T extends LivingEntity, C extends CowConfiguration, M extends EntityModel<?>>
extends LivingEntityRenderState
implements CowVariantRenderState<T, C, M> {
    public Holder<CowVariant<C>> cowVariant;
    private final Map<RenderStateObject.Type<Object>, Object> renderStateObject = new HashMap<RenderStateObject.Type<Object>, Object>();
    private final Map<CowModelType, Pair<M, M>> models = new HashMap<CowModelType, Pair<M, M>>();
    private final Function<ModelLayerLocation, M> bakeLayerFunction;

    public AbstractCowTypeRenderState(Function<ModelLayerLocation, M> bakeLayerFunction) {
        this.bakeLayerFunction = bakeLayerFunction;
    }

    @Override
    public void extractDefaultRenderStates(T entity) {
        RenderStateObject.setupGlobalObjects(this.renderStateObject, entity);
    }

    @Override
    public void extractModel(LivingEntityRenderer<T, ?, M> renderer, T entity) {
        if (renderer instanceof AgeableMobRendererAccessor) {
            AgeableMobRendererAccessor accessor = (AgeableMobRendererAccessor)renderer;
            CowVariantAttachment attachment = BovinesAndButtercups.getHelper().getCowVariantAttachment((LivingEntity)entity);
            CowModelType cowModel = null;
            if (attachment != null) {
                cowModel = ((CowVariant)attachment.cowVariant().value()).configuration().model();
            }
            if (cowModel == null) {
                cowModel = BovinesCowModelTypes.DEFAULT;
            }
            ResourceLocation namedEntityTypeLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (cowModel.namespaceOverride() != null) {
                namedEntityTypeLocation = ResourceLocation.fromNamespaceAndPath((String)cowModel.namespaceOverride(), (String)namedEntityTypeLocation.getPath());
            }
            if (cowModel.pathOverride() != null) {
                namedEntityTypeLocation = namedEntityTypeLocation.withPath(cowModel.pathOverride());
            }
            if (!this.models.containsKey(cowModel)) {
                EntityModel adultModel = (EntityModel)this.bakeLayerFunction.apply(new ModelLayerLocation(namedEntityTypeLocation, "main"));
                EntityModel babyModel = (EntityModel)this.bakeLayerFunction.apply(new ModelLayerLocation(namedEntityTypeLocation.withSuffix(BovinesCowModelTypes.DEFAULT.babySuffix()), "main"));
                this.models.put(cowModel, Pair.of((Object)adultModel, (Object)babyModel));
            }
            accessor.bovinesandbuttercups$setAdultModel((EntityModel)this.models.get(cowModel).getFirst());
            accessor.bovinesandbuttercups$setBabyModel((EntityModel)this.models.get(cowModel).getSecond());
        }
    }

    @Override
    public Holder<CowVariant<C>> getCowVariant() {
        return this.cowVariant;
    }

    @Override
    public <E> E getRenderStateObject(RenderStateObject.Type<E> value) {
        return (E)this.renderStateObject.get(value);
    }
}

