/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api.model.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.PlaceableEdibleCondition;
import house.greenhouse.bovinesandbuttercups.client.util.BovinesModelSetUtil;
import house.greenhouse.bovinesandbuttercups.content.block.PlaceableEdibleBlock;
import house.greenhouse.bovinesandbuttercups.content.block.entity.PlaceableEdibleBlockEntity;
import house.greenhouse.bovinesandbuttercups.util.IntRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.compress.utils.Lists;

public record ValueCondition(Optional<IntRange> bites, Map<Either<TagKey<Item>, List<ResourceKey<Item>>>, AttachmentValues> attachments) implements PlaceableEdibleCondition
{
    private static final Map<ValueCondition, List<List<ItemStack>>> LIST_IDS = new ConcurrentHashMap<ValueCondition, List<List<ItemStack>>>();

    @Override
    public boolean test(PlaceableEdibleBlockEntity blockEntity) {
        Registry registry = blockEntity.getLevel().registryAccess().lookupOrThrow(Registries.ITEM);
        return !(!this.bites.isEmpty() && !this.bites.get().test((Integer)blockEntity.getBlockState().getValue((Property)PlaceableEdibleBlock.BITES)) || !this.attachments.isEmpty() && !this.attachments.entrySet().stream().allMatch(entry -> {
            if (((Boolean)((Either)entry.getKey()).map(itemTagKey -> registry.get(itemTagKey).isEmpty(), itemResourceKeys -> itemResourceKeys.stream().noneMatch(key -> registry.get(key).isEmpty()))).booleanValue() || !blockEntity.getAttachments().containsKey(((Either)entry.getKey()).map(itemTagKey -> registry.get(itemTagKey).map(holders -> holders).orElseGet(HolderSet::empty), itemResourceKeys -> HolderSet.direct(itemResourceKeys.stream().map(key -> registry.get(key).orElse(null)).filter(Objects::nonNull).toList())))) {
                return false;
            }
            PlaceableEdibleBlockEntity.AttachmentState state = blockEntity.getAttachments().get(((Either)entry.getKey()).map(itemTagKey -> registry.getOrThrow(itemTagKey), itemResourceKeys -> HolderSet.direct(itemResourceKeys.stream().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0)).toList())));
            for (int i = 0; i < state.items().size(); ++i) {
                if (!((AttachmentValues)entry.getValue()).index().isEmpty() && !((AttachmentValues)entry.getValue()).index().get().test(i)) continue;
                int finalI = i;
                return ((AttachmentValues)entry.getValue()).items().stream().anyMatch(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)state.items().get(finalI))) && (((AttachmentValues)entry.getValue()).active().isEmpty() || ((AttachmentValues)entry.getValue()).active().get().booleanValue() == state.active());
            }
            return false;
        }));
    }

    @Override
    public String toModelVariantString() {
        ArrayList strings = Lists.newArrayList();
        if (this.bites.isPresent()) {
            if (this.bites.get().min().isPresent()) {
                strings.add("bites.min." + String.valueOf(this.bites.get().min().get()));
            }
            if (this.bites.get().max().isPresent()) {
                strings.add("bites.max." + String.valueOf(this.bites.get().max().get()));
            }
        }
        if (!this.attachments.isEmpty()) {
            strings.add("attachments." + String.join((CharSequence)"-", this.attachments.entrySet().stream().map(entry -> {
                ArrayList str = Lists.newArrayList();
                str.add((String)((Either)entry.getKey()).map(tagKey -> "tag." + tagKey.location().toString().replace(":", ".separator."), key -> "items." + String.join((CharSequence)"-", key.stream().map(key1 -> key1.location().toString().replace(":", ".separator.")).toList())));
                str.add("stackid." + ((AttachmentValues)entry.getValue()).getListId(this));
                if (((AttachmentValues)entry.getValue()).index.isPresent()) {
                    if (((AttachmentValues)entry.getValue()).index.get().min().isPresent()) {
                        str.add("index.min." + String.valueOf(((AttachmentValues)entry.getValue()).index.get().min().get()));
                    }
                    if (((AttachmentValues)entry.getValue()).index.get().max().isPresent()) {
                        str.add("index.max." + String.valueOf(((AttachmentValues)entry.getValue()).index.get().max().get()));
                    }
                }
                ((AttachmentValues)entry.getValue()).active.ifPresent(bool -> str.add("active." + bool));
                return String.join((CharSequence)"-", str);
            }).toList()));
        }
        return String.join((CharSequence)"-", strings);
    }

    public record AttachmentValues(List<ItemStack> items, Optional<IntRange> index, Optional<Boolean> active) {
        public static final Codec<AttachmentValues> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BovinesModelSetUtil.ITEM_OR_STRICT_STACK.listOf().fieldOf("items").forGetter(AttachmentValues::items), (App)IntRange.codec(0, 15).optionalFieldOf("index").forGetter(AttachmentValues::index), (App)Codec.BOOL.optionalFieldOf("active").forGetter(AttachmentValues::active)).apply((Applicative)inst, AttachmentValues::new));

        public int getListId(ValueCondition condition) {
            if (!LIST_IDS.containsKey(condition)) {
                LIST_IDS.compute(condition, (con, list) -> {
                    if (list == null) {
                        list = new ArrayList<List<ItemStack>>();
                    }
                    list.add(this.items);
                    return list;
                });
            }
            return LIST_IDS.get(condition).indexOf(this.items);
        }
    }
}

