/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api.model.type;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSet;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.PlaceableEdibleSelector;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.BovinesModelSetType;
import house.greenhouse.bovinesandbuttercups.client.renderer.block.model.PlaceableEdibleMultiPart;
import house.greenhouse.bovinesandbuttercups.content.block.PlaceableEdibleBlock;
import house.greenhouse.bovinesandbuttercups.content.block.entity.PlaceableEdibleBlockEntity;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EdibleBlockBovinesModelSetType
implements BovinesModelSetType {
    public static final EdibleBlockBovinesModelSetType INSTANCE = new EdibleBlockBovinesModelSetType();
    private static final Map<ResourceLocation, EdibleModelDefinition> LOADED = new HashMap<ResourceLocation, EdibleModelDefinition>();

    protected EdibleBlockBovinesModelSetType() {
    }

    public static BakedModel getBlockModel(BovinesModelSet modelSet, PlaceableEdibleBlockEntity blockEntity) {
        Optional<PlaceableEdibleSelector> first;
        if (modelSet == null || blockEntity.getEdibleType() == null) {
            return Minecraft.getInstance().getModelManager().getMissingModel();
        }
        if (!modelSet.lookupKeys().isEmpty() && modelSet.lookupKeys().getFirst() instanceof PlaceableEdibleSelector && (first = modelSet.lookupKeys().stream().map(object -> (PlaceableEdibleSelector)object).filter(placeableEdibleSelector -> placeableEdibleSelector.test(blockEntity)).findFirst()).isPresent()) {
            return modelSet.getModel(first.get());
        }
        return modelSet.getModel(((ResourceKey)blockEntity.getEdibleType().holder().unwrapKey().orElseThrow()).location().withPath(s -> s + "/" + EdibleBlockBovinesModelSetType.acceptedProperties(blockEntity)), ((ResourceKey)blockEntity.getEdibleType().holder().unwrapKey().orElseThrow()).location().withPath(s -> s + "/"), () -> "Could not get edible block bovines model set for type \"" + String.valueOf(modelSet.id()) + "\" with properties \"" + EdibleBlockBovinesModelSetType.acceptedProperties(blockEntity) + "\".");
    }

    @Override
    public BovinesModelSet createReference(ResourceLocation fileId, JsonObject json) {
        HashMap<ResourceLocation, ResourceLocation> modelIds = new HashMap<ResourceLocation, ResourceLocation>();
        HashMap<Object, ResourceLocation> lookup = new HashMap<Object, ResourceLocation>();
        EdibleModelDefinition definition = (EdibleModelDefinition)EdibleModelDefinition.GSON.fromJson((JsonElement)json, EdibleModelDefinition.class);
        if (definition != null) {
            if (definition.multiPart != null) {
                for (PlaceableEdibleSelector selector : definition.multiPart.getEdibleSelectors()) {
                    ResourceLocation filePath = fileId.withPath(s -> s + "/" + selector.condition().toModelVariantString());
                    ResourceLocation resolvedPath = filePath.withPath(s -> "bovinesandbuttercups/" + s);
                    modelIds.put(filePath, resolvedPath);
                    lookup.put(selector, filePath);
                    LOADED.put(resolvedPath, definition);
                }
            } else if (!definition.variants.isEmpty()) {
                Map<ResourceLocation, ResourceLocation> locations = definition.variants.keySet().stream().map(multiVariant -> {
                    ResourceLocation filePath = fileId.withPath(s -> s + "/" + EdibleBlockBovinesModelSetType.mapVariant(multiVariant));
                    ResourceLocation resolvedPath = filePath.withPath(s -> "bovinesandbuttercups/" + s);
                    return Pair.of((Object)filePath, (Object)resolvedPath);
                }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
                modelIds.putAll(locations);
                locations.values().forEach(rl -> LOADED.put((ResourceLocation)rl, definition));
            }
        }
        return new BovinesModelSet(fileId, this, modelIds, lookup);
    }

    @Override
    public UnbakedModel createUnbaked(ResourceLocation modelId) {
        final EdibleModelDefinition definition = LOADED.get(modelId);
        LOADED.remove(modelId);
        if (definition == null) {
            BovinesAndButtercups.LOG.warn("Failed to load model {} defaulting to missing model.", (Object)modelId);
            return MissingBlockModel.missingModel();
        }
        if (definition.multiPart() != null) {
            return new UnbakedModel(){

                public BakedModel bake(TextureSlots textureSlots, ModelBaker baker, ModelState modelState, boolean hasAmbientOcclusion, boolean useBlockLight, ItemTransforms transforms) {
                    return definition.multiPart().bake(baker);
                }

                public void resolveDependencies(ResolvableModel.Resolver resolver) {
                    definition.multiPart().resolveDependencies(resolver);
                }
            };
        }
        String variant = EdibleBlockBovinesModelSetType.getVariant(modelId);
        final MultiVariant multiVariant = definition.variants().containsKey(variant) ? definition.variants().get(variant) : definition.variants().get("");
        if (multiVariant == null) {
            BovinesAndButtercups.LOG.warn("Failed to load model {} with variant {} defaulting to missing model.", (Object)modelId.withPath(s -> s.replace("/" + EdibleBlockBovinesModelSetType.mapVariant(variant), "")), (Object)variant);
            return MissingBlockModel.missingModel();
        }
        return new UnbakedModel(){

            public BakedModel bake(TextureSlots textureSlots, ModelBaker baker, ModelState modelState, boolean hasAmbientOcclusion, boolean useBlockLight, ItemTransforms transforms) {
                return multiVariant.bake(baker);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                multiVariant.resolveDependencies(resolver);
            }
        };
    }

    private static String acceptedProperties(PlaceableEdibleBlockEntity blockEntity) {
        String attachments = EdibleBlockBovinesModelSetType.mapVariant(blockEntity.attachmentsToString());
        return "bites." + String.valueOf(blockEntity.getBlockState().getValue((Property)PlaceableEdibleBlock.BITES)) + (String)(attachments.isEmpty() ? "" : "-attachments." + EdibleBlockBovinesModelSetType.mapVariant(blockEntity.attachmentsToString()));
    }

    private static String mapVariant(String variant) {
        return variant.replaceAll("#", "tag.").replace(":", ".separator.").replaceAll("=", ".").replaceAll(",", "-");
    }

    private static String getVariant(ResourceLocation modelId) {
        String path = modelId.getPath();
        if (path.lastIndexOf("/") == path.length() - 1) {
            return "";
        }
        return path.substring(path.lastIndexOf("/") + 1).replaceAll("tag.", "#").replace(".separator.", ":").replaceAll("\\.", "=").replaceAll("-", ",");
    }

    private record EdibleModelDefinition(Map<String, MultiVariant> variants, @Nullable PlaceableEdibleMultiPart multiPart) {
        public static final Gson GSON = new GsonBuilder().registerTypeAdapter(EdibleModelDefinition.class, (Object)new Deserializer()).registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).registerTypeAdapter(MultiVariant.class, (Object)new MultiVariant.Deserializer()).registerTypeAdapter(PlaceableEdibleMultiPart.class, (Object)new PlaceableEdibleMultiPart.Deserializer()).registerTypeAdapter(PlaceableEdibleSelector.class, (Object)new PlaceableEdibleSelector.Deserializer()).create();

        public static class Deserializer
        implements JsonDeserializer<EdibleModelDefinition> {
            public EdibleModelDefinition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonobject = json.getAsJsonObject();
                Map<String, MultiVariant> map = this.getVariants(context, jsonobject);
                PlaceableEdibleMultiPart multipart$definition = this.getMultiPart(context, jsonobject);
                if (map.isEmpty() && multipart$definition == null) {
                    throw new JsonParseException("Neither 'variants' nor 'multipart' found");
                }
                return new EdibleModelDefinition(map, multipart$definition);
            }

            protected Map<String, MultiVariant> getVariants(JsonDeserializationContext context, JsonObject json) {
                HashMap map = Maps.newHashMap();
                if (json.has("variants")) {
                    JsonObject jsonobject = GsonHelper.getAsJsonObject((JsonObject)json, (String)"variants");
                    for (Map.Entry entry : jsonobject.entrySet()) {
                        map.put((String)entry.getKey(), (MultiVariant)context.deserialize((JsonElement)entry.getValue(), MultiVariant.class));
                    }
                }
                return map;
            }

            @Nullable
            protected PlaceableEdibleMultiPart getMultiPart(JsonDeserializationContext context, JsonObject json) {
                if (!json.has("multipart")) {
                    return null;
                }
                JsonArray jsonarray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"multipart");
                return (PlaceableEdibleMultiPart)((Object)context.deserialize((JsonElement)jsonarray, PlaceableEdibleMultiPart.class));
            }
        }
    }
}

