/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.api.model.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import house.greenhouse.bovinesandbuttercups.BovinesAndButtercups;
import house.greenhouse.bovinesandbuttercups.client.api.model.BovinesModelSet;
import house.greenhouse.bovinesandbuttercups.client.api.model.type.BovinesModelSetType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.jetbrains.annotations.Nullable;

public class GenericBovinesModelSetType
implements BovinesModelSetType {
    public static final GenericBovinesModelSetType INSTANCE = new GenericBovinesModelSetType();
    private static final StateDefinition<Block, BlockState> EMPTY_STATE = new StateDefinition.Builder((Object)Blocks.AIR).create(Block::defaultBlockState, BlockState::new);
    private static final Map<ResourceLocation, JsonObject> LOADED_JSON = new HashMap<ResourceLocation, JsonObject>();

    protected GenericBovinesModelSetType() {
    }

    @Override
    public BovinesModelSet createReference(ResourceLocation fileId, JsonObject json) {
        Map<ResourceLocation, ResourceLocation> modelIds = Map.of(fileId, fileId.withPath(s -> "bovinesandbuttercups/" + s));
        LOADED_JSON.put(modelIds.get(fileId), json);
        return new BovinesModelSet(fileId, this, modelIds, Map.of());
    }

    @Override
    public UnbakedModel createUnbaked(ResourceLocation modelId) {
        JsonObject json = LOADED_JSON.get(modelId);
        LOADED_JSON.remove(modelId);
        JsonObject blockStateJson = GenericBovinesModelSetType.remapToBlockStateJson(json);
        if (blockStateJson == null) {
            return MissingBlockModel.missingModel();
        }
        Map definition = BlockModelDefinition.fromJsonElement((JsonElement)blockStateJson).instantiate(EMPTY_STATE, modelId.toString());
        final Optional variant = definition.values().stream().findFirst();
        if (variant.isEmpty()) {
            return MissingBlockModel.missingModel();
        }
        return new UnbakedModel(){

            public BakedModel bake(TextureSlots textureSlots, ModelBaker baker, ModelState modelState, boolean hasAmbientOcclusion, boolean useBlockLight, ItemTransforms transforms) {
                return ((UnbakedBlockStateModel)variant.get()).bake(baker);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                ((UnbakedBlockStateModel)variant.get()).resolveDependencies(resolver);
            }
        };
    }

    @Nullable
    private static JsonObject remapToBlockStateJson(JsonObject json) {
        if (json == null) {
            return null;
        }
        if (!json.has("model")) {
            BovinesAndButtercups.LOG.warn("\"bovinesandbuttercups:generic\" bovines model set does not have a \"model\" field. This field must be either a model's location or a multipart with \"state_type\" set to 'multipart'.");
            return null;
        }
        JsonObject root = new JsonObject();
        StateType stateType = StateType.VARIANT;
        if (json.has("state_type")) {
            DataResult dataResult = StateType.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("state_type"));
            if (dataResult.isError()) {
                BovinesAndButtercups.LOG.warn("Could not decode \"state_type\" field ({}) in \"bovinesandbuttercups:generic\" bovines model set. Must be either \"variant\" or \"multipart\". (Ignoring).", (Object)json.get("state_type"));
            } else if (((Pair)dataResult.getOrThrow()).getFirst() == StateType.MULTIPART) {
                stateType = StateType.MULTIPART;
            }
        }
        if (stateType == StateType.MULTIPART) {
            if (!json.get("model").isJsonArray()) {
                BovinesAndButtercups.LOG.error("\"model\" field ({}) in multipart \"bovinesandbuttercups:generic\" is not a valid multipart.", (Object)json.get("model"));
                return null;
            }
            root.add("multipart", json.get("model"));
        } else {
            if (!json.get("model").isJsonPrimitive() || !json.get("model").getAsJsonPrimitive().isString()) {
                BovinesAndButtercups.LOG.error("\"model\" field ({}) in variant \"bovinesandbuttercups:generic\" is not a valid model location.", (Object)json.get("model"));
                return null;
            }
            JsonObject variants = new JsonObject();
            JsonObject model = new JsonObject();
            model.add("model", json.get("model"));
            variants.add("", (JsonElement)model);
            root.add("variants", (JsonElement)variants);
        }
        return root;
    }

    public static enum StateType implements StringRepresentable
    {
        VARIANT("variant"),
        MULTIPART("multipart");

        public static final Codec<StateType> CODEC;
        private String name;

        private StateType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(StateType::values);
        }
    }
}

