/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.bovinesandbuttercups.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.bovinesandbuttercups.client.BovinesAndButtercupsClient;
import house.greenhouse.bovinesandbuttercups.client.api.model.condition.PlaceableEdibleSelector;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.level.block.state.BlockState;

public class PlaceableEdibleMultiPart
extends MultiPart {
    private final List<PlaceableEdibleSelector> edibleSelectors;

    public PlaceableEdibleMultiPart(List<PlaceableEdibleSelector> edibleSelectors) {
        super(List.of());
        this.edibleSelectors = edibleSelectors;
    }

    public List<PlaceableEdibleSelector> getEdibleSelectors() {
        return this.edibleSelectors;
    }

    public Object visualEqualityGroup(BlockState state) {
        throw new UnsupportedOperationException("PlaceableEdibleMultiPart does not support MultiPart#visualEqualityGroup");
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        this.edibleSelectors.forEach(selector -> selector.variant().resolveDependencies(resolver));
    }

    public BakedModel bake(ModelBaker modelBaker) {
        ArrayList<Pair<PlaceableEdibleSelector, BakedModel>> list = new ArrayList<Pair<PlaceableEdibleSelector, BakedModel>>(this.edibleSelectors.size());
        for (PlaceableEdibleSelector selector : this.edibleSelectors) {
            BakedModel bakedmodel = selector.variant().bake(modelBaker);
            list.add((Pair<PlaceableEdibleSelector, BakedModel>)Pair.of((Object)selector, (Object)bakedmodel));
        }
        return BovinesAndButtercupsClient.getHelper().createPlaceableEdibleModel(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlaceableEdibleMultiPart)) return false;
        PlaceableEdibleMultiPart multipart = (PlaceableEdibleMultiPart)((Object)other);
        if (!Objects.equals(this.edibleSelectors, multipart.edibleSelectors)) return false;
        return true;
    }

    public static class Deserializer
    implements JsonDeserializer<PlaceableEdibleMultiPart> {
        public PlaceableEdibleMultiPart deserialize(JsonElement json, Type type, JsonDeserializationContext jsonContext) throws JsonParseException {
            List<PlaceableEdibleSelector> selectors = this.getSelectors(jsonContext, json.getAsJsonArray());
            return new PlaceableEdibleMultiPart(selectors);
        }

        private List<PlaceableEdibleSelector> getSelectors(JsonDeserializationContext jsonContext, JsonArray elements) {
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonelement : elements) {
                list.add((PlaceableEdibleSelector)jsonContext.deserialize(jsonelement, PlaceableEdibleSelector.class));
            }
            return list;
        }
    }
}

